function [vega, var, CI] = CallVegaLRAV(S0,K,r,T,sigma,NRepl)

nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);
LRT = zeros(1,NRepl);

for i = 1:NRepl
    Z1 = randn;
    St1 = S0*exp(nuT+siT*Z1);
    score1 = (Z1.^2-1)/sigma-Z1*sqrt(T);
    dPayoff1 = exp(-r*T)*max(0,St1-K);
    LRT1 = dPayoff1*score1;

    Z2 = -Z1;
    St2 = S0*exp(nuT+siT*Z2);
    score2 = (Z2.^2-1)/sigma-Z2*sqrt(T);
    dPayoff2 = exp(-r*T)*max(0,St2-K);
    LRT2 = dPayoff2*score2;
    
    LRT(i) = (LRT1+LRT2)/2;
end

[vega, var, CI] = normfit(LRT);