function [vega, var, CI] = CallVegaLR(S0,K,r,T,sigma,NRepl)

Z = randn(NRepl,1);
nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);

score = (Z.^2-1)/sigma-Z*sqrt(T);
dPayoff = exp(-r*T)*max(0,S0*exp(nuT+siT*Z)-K);

LRT = dPayoff.*score;
[vega, var, CI] = normfit(LRT);