function [delta, var, CI] = CallVegaFDCN(S0,K,r,T,sigma,NRepl,eps)

payoff1 = zeros(1,NRepl);
payoff2 = zeros(1,NRepl);
par = 'vega';

for i = 1:NRepl
    [Path1, Path2] =AssetPaths2(S0,r,sigma,T,1,1,eps,par);
    payoff1(i) = max(0, Path1(2) - K);
    payoff2(i) = max(0, Path2(2) - K);
end

[delta, var, CI] = normfit(exp(-r*T)*(payoff1-payoff2)/(2*eps));