function [rho, var, CI] = CallRhoLRAV(S0,K,r,T,sigma,NRepl)

nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);
LRT = zeros(1,NRepl);

for i = 1:NRepl
    Z1 = randn;
    St1 = S0*exp(nuT+siT*Z1);
    d1 = (log(St1/S0)-nuT)/siT;
    score1 = -T+d1.*sqrt(T)./sigma;
    dPayoff1 = exp(-r*T)*max(0,St1-K);
    LRT1 = dPayoff1*score1;

    Z2 = -Z1;
    St2 = S0*exp(nuT+siT*Z2);
    d2 = (log(St2/S0)-nuT)/siT;
    score2 = -T+d2.*sqrt(T)./sigma;
    dPayoff2 = exp(-r*T)*max(0,St2-K);
    LRT2 = dPayoff2*score2;
    
    LRT(i) = (LRT1+LRT2)/2;
end

[rho, var, CI] = normfit(LRT);