function [rho, var, CI] = CallRhoLR(S0,K,r,T,sigma,NRepl)

Z = randn(NRepl,1);
nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);
St = S0*exp(nuT+siT*Z);
d = (log(St/S0)-nuT)/siT;

score = -T+d.*sqrt(T)./sigma;
dPayoff = exp(-r*T)*max(0,St-K);

LRT = dPayoff.*score;
[rho, var, CI] = normfit(LRT);