function rho = CallRhoAnalytic(S0, K, r, T, sigma)
    d1 = (log(S0 / K) + (r + 0.5 * sigma^2) * T) / (sigma * sqrt(T));
    d2 = d1-sigma*sqrt(T);
    rho = exp(-r*T)*K*T*normcdf(d2);
end