function [gamma, var, CI] = CallGammaLR(S0,K,r,T,sigma,NRepl)

Z = randn(NRepl,1);
nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);
St = S0*exp(nuT+siT*Z);
d = (log(St/S0)-nuT)/siT;

score = (d.^2-d.*siT-1)./(S0*siT)^2;
dPayoff = exp(-r*T)*max(0,St-K);

LRT = dPayoff.*score;
[gamma, var, CI] = normfit(LRT);