function [gamma, var, CI] = CallGammaFDCN(S0,K,r,T,sigma,NRepl,dS)
nuT = (r-0.5*sigma^2)*T;
siT= sigma * sqrt(T);
SampleDiff = zeros(1,NRepl);

for i = 1:NRepl
    Z = randn;
    Payoff1 = max(0, (S0)*exp(nuT+siT*Z)-K);
    Payoff2 = max(0, (S0+dS)*exp(nuT+siT*Z)-K);
    Payoff3 = max(0, (S0-dS)*exp(nuT+siT*Z)-K);
    SampleDiff(i) = exp(-r*T)*(Payoff2-2*Payoff1+Payoff3)/(dS^2);
end

[gamma, var, CI] = normfit(SampleDiff);

