function [delta, var, CI] = CallDeltaLRAV(S0,K,r,T,sigma,NRepl)

nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);
LRT = zeros(1,NRepl);

for i = 1:NRepl
    Z1 = randn;
    Z2 = -Z1;
    score1 = Z1/(S0*siT);
    dPayoff1 = exp(-r*T)*max(0,S0*exp(nuT+siT*Z1)-K);
    score2 = Z2/(S0*siT);
    LRT1 = dPayoff1*score1;
    dPayoff2 = exp(-r*T)*max(0,S0*exp(nuT+siT*Z2)-K);
    LRT2 = dPayoff2*score2;
    LRT(i) = (LRT1+LRT2)/2;
end

[delta, var, CI] = normfit(LRT);
