function [delta, var, CI] = CallDeltaLR(S0,K,r,T,sigma,NRepl)

Z = randn(NRepl,1);
nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);

score = Z/(S0*siT);
dPayoff = exp(-r*T)*max(0,S0*exp(nuT+siT*Z)-K);

LRT = dPayoff.*score;
[delta, var, CI] = normfit(LRT);
