function [SPaths1 ,SPaths2, SPaths3] =AssetPaths3(S0,r,sigma,T,NSteps,NRepl,eps)

SPaths1 = zeros(NRepl, 1+NSteps);
SPaths2 = zeros(NRepl, 1+NSteps);
SPaths3 = zeros(NRepl, 1+NSteps);
SPaths1(:,1) = S0+eps;
SPaths2(:,1) = S0-eps;
SPaths3(:,1) = S0;

dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);

for i=1:NRepl
   for j=1:NSteps
      Z = randn;
      SPaths1(i,j+1)=SPaths1(i,j)*exp(nudt + sidt*Z);
      SPaths2(i,j+1)=SPaths2(i,j)*exp(nudt + sidt*Z);
      SPaths3(i,j+1)=SPaths3(i,j)*exp(nudt + sidt*Z);
   end
end