function [SPaths1 ,SPaths2] =AssetPaths2(S0,r,sigma,T,NSteps,NRepl,eps,par)
SPaths1 = zeros(NRepl, 1+NSteps);
SPaths2 = zeros(NRepl, 1+NSteps);
SPaths1(:,1) = S0;
SPaths2(:,1) = S0;
r1 = r;
r2 = r;
sigma1 = sigma;
sigma2 = sigma;
switch par
    case 'delta'
        SPaths1(:,1) = S0+eps;
        SPaths2(:,1) = S0-eps;
    case 'vega'
        sigma1 = sigma+eps;
        sigma2 = sigma-eps;
    case 'rho'
        r1 = r+eps;
        r2 = r-eps;
end

dt = T/NSteps;
nudt1 = (r1-0.5*sigma1^2)*dt;
sidt1 = sigma1*sqrt(dt);
nudt2 = (r2-0.5*sigma2^2)*dt;
sidt2 = sigma2*sqrt(dt);
for i=1:NRepl
   for j=1:NSteps
      Z = randn;
      SPaths1(i,j+1)=SPaths1(i,j)*exp(nudt1 + sidt1*Z);
      SPaths2(i,j+1)=SPaths2(i,j)*exp(nudt2 + sidt2*Z);
   end
end