function [Vega, var, CI] = AsianVegaPath(S0,K,r,T,sigma,NSteps,NRepl)

paths = AssetPaths(S0,r,sigma,T,NSteps,NRepl);

dt = repmat(linspace(1/NSteps, 1, NSteps), NRepl, 1);
dSdsigma = paths(:, 2:end).*(log(paths(:, 2:end)/S0)-(r+1/2*sigma^2).*dt)/sigma;

dSdsigmabar = mean(dSdsigma,2);
Sbar = mean(paths(:,2:end),2);

SampleDelta = exp(-r*T) .* dSdsigmabar .* (Sbar > K);
[Vega, var, CI] = normfit(SampleDelta);