function [vega, var, CI] = AsianVegaLRAV(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation 
SPaths1 = zeros(1, 1+NSteps);
SPaths1(1) = S0;

SPaths2 = zeros(1, 1+NSteps);
SPaths2(1) = S0;

dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
LR = zeros(1,NRepl);

for i=1:NRepl
   score1 = 0;
   score2 = 0;
   for j=1:NSteps
      Z1 = randn;
      Z2 = -Z1;
      SPaths1(j+1)=SPaths1(j)*exp(nudt+sidt*Z1);
      SPaths2(j+1)=SPaths2(j)*exp(nudt+sidt*Z2);
      score1 = score1+(Z1^2-1)/sigma-Z1*sqrt(dt);
      score2 = score2+(Z2^2-1)/sigma-Z2*sqrt(dt);
   end
   payoff1 = exp(-r*T)*max(0, mean(SPaths1(2:end),2)-K);
   LR1 = payoff1*score1;

   payoff2 = exp(-r*T)*max(0, mean(SPaths2(2:end),2)-K); 
   LR2 = payoff2*score2;
   
   LR(i) = (LR1+LR2)/2;
end


[vega, var, CI] = normfit(LR);