function [vega, var, CI] = AsianVegaLR(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation 
SPaths = zeros(NRepl, 1+NSteps);
SPaths(:,1) = S0;
score = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
for i=1:NRepl
   for j=1:NSteps
      Z = randn;
      SPaths(i,j+1)=SPaths(i,j)*exp(nudt+sidt*Z);
      score(i) = score(i)+(Z^2-1)/sigma-Z*sqrt(dt);
   end
end

Sbar = mean(SPaths(:,2:end),2);

dPayoff = exp(-r*T)*max(0,Sbar-K);

LR = dPayoff.*score;
[vega, var, CI] = normfit(LR);