function [rho, var, CI] = AsianRhoPath(S0,K,r,T,sigma,NSteps,NRepl)
paths = AssetPaths(S0,r,sigma,T,NSteps,NRepl);
paths = paths(:,2:end);
dt = T/NSteps;
ones = linspace(1,NSteps,NSteps);
Sbar = mean(paths,2);
dSbardr = 1/NSteps*sum(dt*ones.*paths,2);
SampleDelta = -T* exp(-r*T)*max(Sbar-K,0)+exp(-r*T).* (dSbardr.* (Sbar > K));
[rho, var, CI] = normfit(SampleDelta);