function [rho, var, CI] = AsianRhoLRAV(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation 
SPaths1 = zeros(1, 1+NSteps);
SPaths1(1) = S0;
d1 = zeros(1,NSteps);

SPaths2 = zeros(1, 1+NSteps);
SPaths2(1) = S0;
d2= zeros(1,NSteps);

LR = zeros(1,NSteps);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);

for i=1:NRepl
   for j=1:NSteps
      Z1 = randn;
      Z2 = -Z1;
      SPaths1(j+1)=SPaths1(j)*exp(nudt+sidt*Z1);
      SPaths2(j+1)=SPaths2(j)*exp(nudt+sidt*Z2);
      d1(j)=(log(SPaths1(j+1)/SPaths1(j))-nudt)/sidt;
      d2(j)=(log(SPaths2(j+1)/SPaths2(j))-nudt)/sidt;
   end
   score1 = -T+sqrt(dt).*sum(d1,2)./sigma;
   payoff1 = exp(-r*T)*max(0, mean(SPaths1(2:end),2)-K);
   LR1 = payoff1*score1;
   
   score2 = -T+sqrt(dt).*sum(d2,2)./sigma;
   payoff2 = exp(-r*T)*max(0, mean(SPaths2(2:end),2)-K); 
   LR2 = payoff2*score2;
   
   LR(i) = (LR1+LR2)/2;
end

[rho, var, CI] = normfit(LR);
