function [rho, var, CI] = AsianRhoLR(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation 
SPaths = zeros(NRepl, 1+NSteps);
SPaths(:,1) = S0;
dt = T/NSteps;
d = zeros(NRepl,NSteps);
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);

for i=1:NRepl
   for j=1:NSteps
      Z = randn;
      SPaths(i,j+1)=SPaths(i,j)*exp(nudt+sidt*Z);
      d(i,j) = (log(SPaths(i,j+1)/SPaths(i,j))-nudt)/sidt;
   end
end
Sbar = mean(SPaths(:,2:end),2);

score = -T+sqrt(dt).*sum(d,2)./sigma;
dPayoff = exp(-r*T)*max(0,Sbar-K);

LR = dPayoff.*score;
[rho, var, CI] = normfit(LR);
