function [gamma, var, CI] = AsianGammaLR(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation saving Z1
SPaths = zeros(NRepl, 1+NSteps);
SPaths(:,1) = S0;
d1 = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
for i=1:NRepl
   for j=1:NSteps
      Z = randn;
      SPaths(i,j+1)=SPaths(i,j)*exp(nudt+sidt*Z);
      if j == 1
          d1(i) = (log(SPaths(i,j+1)/SPaths(i,j))-nudt)/sidt;
      end
   end
end

Sbar = mean(SPaths(:,2:end),2);

score = (d1.^2-d1.*sidt-1)./((S0*sidt)^2);
dPayoff = exp(-r*T)*max(0,Sbar-K);

LRT = dPayoff.*score;
[gamma, var, CI] = normfit(LRT);
