function [gamma, var, CI] = AsianGammaFDCN(S0,K,r,T,sigma,NSteps,NRepl,eps)
payoff1 = zeros(1,NRepl);
payoff2 = zeros(1,NRepl);
payoff3 = zeros(1,NRepl);

for i = 1:NRepl
    [Path1, Path2, Path3] = AssetPaths3(S0,r,sigma,T,NSteps,1, eps);
    payoff1(i) = max(0, mean(Path1(2:(NSteps+1))) - K);
    payoff2(i) = max(0, mean(Path2(2:(NSteps+1))) - K);
    payoff3(i) = max(0, mean(Path3(2:(NSteps+1))) - K);
end

[gamma, var, CI] = normfit(exp(-r*T)*(payoff1+payoff2-2*payoff3)/(eps^2));
