function [delta, var, CI] = AsianDeltaLRAV(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation saving Z1
SPaths1 = zeros(1, 1+NSteps);
SPaths1(1) = S0;

SPaths2 = zeros(1, 1+NSteps);
SPaths2(1) = S0;

dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
LRT = zeros(1,NRepl);

for i=1:NRepl
   for j=1:NSteps
      Z1 = randn;
      Z2 = -Z1;
      SPaths1(j+1)=SPaths1(j)*exp(nudt+sidt*Z1);
      SPaths2(j+1)=SPaths2(j)*exp(nudt+sidt*Z2);
      if j == 1
          score1 = Z1/(S0*sigma*sqrt(dt));
          score2 = Z2/(S0*sigma*sqrt(dt));
      end
   end
   payoff1 = exp(-r*T)*max(0, mean(SPaths1(2:end),2)-K);
   LRT1 = payoff1*score1;

   payoff2 = exp(-r*T)*max(0, mean(SPaths2(2:end),2)-K); 
   LRT2 = payoff2*score2;
   
   LRT(i) = (LRT1+LRT2)/2;
end

[delta, var, CI] = normfit(LRT);
