function [delta, var, CI] = AsianDeltaLR(S0,K,r,T,sigma,NSteps,NRepl)

%Asset path generation saving Z1
SPaths = zeros(NRepl, 1+NSteps);
SPaths(:,1) = S0;
Z1 = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
for i=1:NRepl
   for j=1:NSteps
      Z = randn;
      SPaths(i,j+1)=SPaths(i,j)*exp(nudt+sidt*Z);
      if j == 1
          Z1(i) = Z;
      end
   end
end

Sbar = mean(SPaths(:,2:end),2);

score = Z1/(S0*sigma*sqrt(dt));
dPayoff = exp(-r*T)*max(0,Sbar-K);

LRT = dPayoff.*score;
[delta, var, CI] = normfit(LRT);
