function [delta, var, CI] = AsianDeltaFDCN(S0,K,r,T,sigma,NSteps,NRepl,eps)

payoff1 = zeros(1,NRepl);
payoff2 = zeros(1,NRepl);
par = 'delta';

for i = 1:NRepl
    [Path1, Path2] =AssetPaths2(S0,r,sigma,T,NSteps,1, eps,par);
    payoff1(i) = max(0, mean(Path1(2:(NSteps+1))) - K);
    payoff2(i) = max(0, mean(Path2(2:(NSteps+1))) - K);
end

[delta, var, CI] = normfit(exp(-r*T)*(payoff1-payoff2)/(2*eps));
