%% Alpha computing function
% Function that computes the interdependence parameter alpha, between
% obligors

% INPUTS
% - U: uniform matrix with dimensions (w, h)
% - w: number of variales of U
% - h: number of obligors
% - method: method to be used. Available selections are "Tau" and "Select"
% - copula: copula function to be used

% OUTPUT
% - alpha: interdependence parameter

function [alpha] = compute_alpha(U,w,h, method, copula)

% Kendall's Tau method
if method == "Tau"

    if copula == "Gumbel"
        % Gumbel's copula parameter w.r.t. Kendall's Tau
        theta = @(x) 1./(1-x);
    elseif copula == "Clayton"
        % Clayton's copula parameter w.r.t. Kendall's Tau
        theta = @(x) 2*x./(1-x);
    end

    alpha = 0;
    for j1 = 1:h
        for j2 = j1+1:h
            tot = 0;
            for i1 = 1:w
                for i2 = i1+1:w
                    tot = tot + sign((U(i1,j1) - U(i2,j1))*(U(i1,j2)-U(i2,j2)));
                end
            end
            tau = (1/nchoosek(w,2))*tot;
            alpha = alpha + theta(tau); 
        end
    end
    alpha = (1/nchoosek(h,2))*alpha;
end

% With this method at the user is asked to put as input the desired value
% IMPORTANT: if the value is high (e.g. alpha = 50) computation of prob and
% CVaR might fail due to numerical problems.
if method == "Select"

    alpha = input("Insert the value of the interdependence parameter alpha: \n\n");

end
