function [xMCI] = Syn2MCI(t, xSyn, mu)
%
% Transformation from PBR4BP Synodic r.f. to MCI r.f.
%
%DESCRIPTION:
%This code provides transformation from PBR4BP Synodic r.f. to Moon Centred
%Inertial (MCI) r.f.
%
%PROTOTYPE
%   [xMCI] = Syn2MCI(t, xSyn, mu)
%
%--------------------------------------------------------------------------
% INPUTS:
%   t          [1xn]       Time Instant              [-]
%   xSyn       [nx4]       State Vector (Synodic)    [-]
%   mu         [1x1]       System Mass Parameter     [-]
%--------------------------------------------------------------------------
% OUTPUTS:
%   xMCI       [nx4]       State Vector (MCI)        [-]
%--------------------------------------------------------------------------
%
%NOTES:
% (none)
%
%CALLED FUNCTIONS:
% (none)
%
%UPDATES:
% (none)
%
%REFERENCES:
% [1] "On Optimal Two-Impulse Earth-Moon Transfers in a Four-Body Model",
%     Francesco Topputo.
%
%AUTHOR(s):
%Luigi De Maria, 2022
%

%% Transformation

%Memory Allocation
[c,r] = size(xSyn);                       %Input Vector Sizes
xMCI = zeros(c,r);

%State Transformation
xMCI(:,1) = (xSyn(:,1) + mu - 1).*cos(t(:)) - xSyn(:,2).*sin(t(:));
xMCI(:,2) = (xSyn(:,1) + mu - 1).*sin(t(:)) + xSyn(:,2).*cos(t(:));
xMCI(:,3) = (xSyn(:,3) - xSyn(:,2)).*cos(t(:)) - (xSyn(:,4) + xSyn(:,1) + mu - 1).*sin(t(:));
xMCI(:,4) = (xSyn(:,3) - xSyn(:,2)).*sin(t(:)) + (xSyn(:,4) + xSyn(:,1) + mu - 1).*cos(t(:));

end