# Author: Daniel Guarecuco Aguiar <deaguiar@stud.ntnu.no>
#   <daniel.aguiar@nordicsemi.no>
# Created Date: 14/02/2023
# This script reports power and timing from synthesized design
# Generates spice netlist of critical path
# Usage: Intented to be called from main.sh
#   pt_shell -f power.tcl
# # ---------------------------------------------------------------------------

# Get library name from env varible defined in bash script
set TECH_LIB $env(TECH_LIB);
# Get relevant name to be used for saving all files
set OUT_DIR $env(OUT_DIR)
set TECH_CHAN $env(TECH_CHAN)

suppress_message CMD-041

# ############### Specify Libraries # ##########################
set LIB_PATH "/library_path"
set ADDITIONAL_SEARCH_PATH    [list {*}[subst {
  [glob $LIB_PATH/path_to_library]  
  [glob ./]
}]]  ;
set search_path ""
append search_path " $ADDITIONAL_SEARCH_PATH"

set link_library "* "
lappend link_library  $TECH_LIB

set power_enable_analysis true
set case_analysis_propagate_through_icg true
set power_analysis_mode averaged 

read_verilog "$OUT_DIR/ibex_top_map.v"
current_design ibex_top
link_design
read_sdc "$OUT_DIR/ibex_top_sdc.sdc"

set_power_analysis_options -through_mode

update_timing -full

check_power



source $OUT_DIR/ibex_top_name_mapping.tcl
read_saif -strip_path  "/ibex_simple_system/u_top/u_ibex_top" $OUT_DIR/ibex_top.saif

report_switching_activity -list_not_annotated -include_only {rtl}  > $OUT_DIR/not_annotated.txt

update_power
report_switching_activity -list_not_annotated -include_only {rtl}  > $OUT_DIR/not_annotated_post.txt

report_power > $OUT_DIR/report_power.txt
report_timing > $OUT_DIR/report_timing_pt.txt

#Finding CDL file path
set curr_lib_path [which $TECH_LIB]
regsub {liberty\/nldm} $curr_lib_path "cdl"  cdl_path
regsub {_TT\w+.db|_abblvt\w+.nldm.db} $cdl_path ".cdl"  cdl_path

# Writing SPICE netlist
write_spice_deck \
-output $OUT_DIR/netlist_critical_path.sp [get_timing_paths] \
-sub_circuit_file "$cdl_path"

quit