# Author: Daniel Guarecuco Aguiar <deaguiar@stud.ntnu.no>
#   <daniel.aguiar@nordicsemi.no>
# Created Date: 14/02/2023
# This script generates four oceanScript files to run analog simulations on virtuoso
# These four simulations are: Input to gnd, to vdd, to Z and to !Z
# All four top schematics must be first imported by SpiceIn
# 
# Usage: Intented to be called from main.sh
#   python3 generate_ocn.py syn_out/LVT24_25C LVT24
# # ---------------------------------------------------------------------------

import sys
import time
import pandas as pd
import os

def write_ocn(sw_pos):
    ocean_file = dir_path + '/' + "top_sim_"+ str(temp_str) + "C_Excluding_" + str(exclude_cells) + "%_"+ sw_pos+".ocn" 
    if (exclude_cells == "0"):
        result_file = "./results/" + tech +'_'+ str(temp_str) + "C_" +vnw_name + vpw_name +"_"+ current_time +"_top_results_"+ sw_pos+".csv"
    else:
        result_file = "./results/" + tech +'_'+ str(temp_str) + "C_Excluding_"+ str(exclude_cells) + "%_" +vnw_name + vpw_name +"_"+ current_time +"_top_results_"+ sw_pos+".csv"
    maestro = "maestro_top_" + current_time  

    original_stdout = sys.stdout # Save a reference to the original standard output
    with open(ocean_file, 'w') as f:
        sys.stdout = f # Change the standard output to the file we created.
        print(';Script generated by generate_ocn.py')
        print(';====================Set to Maestro mode explorer =============================')
        print('ocnSetXLMode("explorer")')
        print('ocnxlProjectDir( "/my_path/work/virtuoso" )')
        print('ocnxlTargetCellView( "'+testbench+'" "top" "'+maestro+'" )')
        print('ocnxlResultsLocation( "" )')
        print('ocnxlHistoryPrefix("sw_pos_'+sw_pos+'")')
        print('ocnxlSimResultsLocation( "" )')
        print('ocnxlMaxJobFail( 20 )')
        print('')
        print(';====================== Tests setup ============================================')
        print('')
        print(';---------- Test "'+testbench+'_top_1" ------------- ')
        print('ocnxlBeginTest("'+testbench+'_top_1")')
        print('simulator( \'spectre )')
        print('design( "'+testbench+'" "top" "schematic")')
        print('modelFile( ')
        print(')')
        print('analysis(\'tran ?stop "'+sim_stop+'\"  ?errpreset "conservative"  )')
        print('desVar(	  "vdd" 0.4	)')
        print('desVar(	  "vnw_n" 0.4	)')
        print('desVar(	  "vpw_p" 0	)')
        print('desVar(	  "sw_pos" '+sw_pos+')')
        print('envOption(')
        print('	\'analysisOrder  list("pz" "dcmatch" "stb" "tran" "envlp" "ac" "dc" "lf" "noise" "xf" "sp" "pss" "pac" "pstb" "pnoise" "pxf" "psp" "qpss" "qpac" "qpnoise" "qpxf" "qpsp" "hb" "hbac" "hbstb" "hbnoise" "hbxf" "sens" "acmatch") ')
        print(')')
        print('saveOption( ?infoOptions list(list("modelParameter" "models" "rawfile" "" "" "" t) list("element" "inst" "rawfile" "" "" "" t) list("outputParameter" "output" "rawfile" "" "" "" t) list("designParamVals" "parameters" "rawfile" "" "" "" t) list("primitives" "primitives" "rawfile" "" "" "" t) list("subckts" "subckts" "rawfile" "" "" "" t) list("asserts" "assert" "rawfile" "" "" "" nil) list("extremeinfo" "all" "logfile" "" "yes" "" nil) list("allcap" "allcap" "file" "" "" "" nil) list("<Click_To_Add>" "none" "rawfile" "" "" "" nil) ) )')
        print('save( \'v "/A" "/Z" )')
        print('save( \'i "/xtop_01/VDD" )')
        print('temp( '+str(temp)+' ) ')
        print('ocnxlOutputSignal( "/A" ?plot t ?save t)')
        print('ocnxlOutputSignal( "/Z" ?plot t ?save t)')
        print('ocnxlOutputExpr( "frequency(clip(VT(\\"/Z\\") (lastVal(VT(\\"/Z\\")) / 2) lastVal(VT(\\"/Z\\"))))" ?name "Frequency" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "dutyCycle(VT(\\"/Z\\") ?mode \\"user\\" ?threshold (VAR(\\"vdd\\") / 2) ?xName \\"time\\" ?outputType \\"average\\")" ?name "DutyCycle" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "average(clip((VAR(\\"vdd\\") * IT(\\"/xtop_01/VDD\\")) (lastVal(VT(\\"/Z\\")) / 2) lastVal(VT(\\"/Z\\"))))" ?name "Power" ?plot t ?evalType \'point)')
        print('ocnxlOutputTerminal( "/xtop_01/VDD" ?save t)')
        print('ocnxlOutputExpr( "delay(?wf1 VT(\\"/A\\") ?value1 (VAR(\\"vdd\\") / 2) ?edge1 \\"either\\" ?nth1 1 ?td1 0.0 ?tol1 nil ?wf2 VT(\\"/Z\\") ?value2 (VAR(\\"vdd\\") / 2) ?edge2 \\"either\\" ?nth2 1 ?tol2 nil ?td2 nil ?stop nil ?multiple nil)" ?name "Delay" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "lastVal(VT(\\"/Z\\"))" ?name "SimTime" ?plot t ?evalType \'point)')
        print('ocnxlEndTest() ; "'+testbench+'_top_1"')
        print('')
        print(';====================== Sweeps setup ===========================================')
        print('')
        print(';====================== Model Group setup ==========================================')
        print('')
        print(';====================== Corners setup ==========================================')
        
        for vdd in corners:
            print('ocnxlCorner( "tc_'+vdd+'_'+str(temp_str)+'"')
            print('   \'(')
            print('      ("variable" "vdd" "'+vdd+'")')
            print('      ("variable" "vnw_n" "'+str(corners_df[vdd].loc['vnw_n'])+'")')
            print('      ("variable" "vpw_p" "'+str(corners_df[vdd].loc['vpw_p'])+'")')
            print('      ("variable" "temperature" "'+str(temp)+'")')
            print('      ("model" "HERE GOES TRANSISTOR MODEL" ?section "\\"tt\\" \\"ff\\" \\"ss\\"")')
            print('      ("modelGroup" "")')
            print('   )')
            print(')')
        print('')
        print(';====================== Checks and Asserts setup ============================================')
        print('ocnxlPutChecksAsserts(?netlist nil)')
        print('')
        print(';====================== Job setup ==============================================')
        print('ocnxlJobSetup( \'(')
        print(') )')
        print('')
        print(';====================== Disabled items =========================================')
        print(';ocnxlDisableCorner("tc_0.80_25") **This disables a corner')
        print('ocnxlSetAllParametersDisabled(t)')
        print('')
        print(';====================== Run Mode Options ======================================')
        print('')
        print(';====================== Starting Point Info ======================================')
        print('')
        print(';====================== Run command ============================================')
        print('printf("*********************************************************************************************\\n")')
        print('printf("Running simulation with switch position = '+sw_pos+'\\n")')
        print('printf("*********************************************************************************************\\n")')
        print('ocnxlRun( ?mode \'sweepsAndCorners ?nominalCornerEnabled nil ?allCornersEnabled t ?allSweepsEnabled t)')
        print('ocnxlOutputSummary(?exprSummary t ?specSummary t ?detailed t ?wave t)')
        print('ocnxlExportOutputView("'+result_file+'" "Detail")')
        print('ocnxlOpenResults()')
        print('')
        print(';====================== End XL Mode command ===================================')
        print('ocnxlEndXLMode("explorer")')
        print('exit()')
        print('')

        sys.stdout = original_stdout # Reset the standard output to its original value

    print('Simulation file saved in '+ ocean_file)


#dir_path = "./syn_out/LVT24_25C/"
dir_path = sys.argv[1]
#tech = "LVT24"
tech = sys.argv[2]
testbench = tech + "_Testbench"
temp_str = sys.argv[3]
temp = int(temp_str.replace('m', '-'))

exclude_cells = os.getenv('exclude_cells') # Percetage excluded

t = time.localtime()
current_time = time.strftime("%H%M%S", t)

sim_stop = '400m'

#corner_csv = dir_path +'/../'+tech+'_'+str(temp_str)+'C_corners.csv'
corner_csv = dir_path +'/../'+tech+'_'+'25C_corners.csv'
corners_df = pd.read_csv (corner_csv,index_col=0)
print(corners_df)
vnw_name = str(corners_df.iloc[0,0])
vpw_name = str(corners_df.iloc[1,0])
vpw_name = vpw_name.replace('-', 'm')
corners = corners_df.columns.values

print('Generating OCN scripts.')
write_ocn("1")
write_ocn("2")
write_ocn("3")
write_ocn("4")
print('Done...')