# Author: Daniel Guarecuco Aguiar <deaguiar@stud.ntnu.no>
#   <daniel.aguiar@nordicsemi.no>
# Created Date: 14/02/2023
# This script generates four oceanScript files to run analog simulations on virtuoso
# These four simulations are: Input to gnd, to vdd, to Z and to !Z
# All four top schematics must be first imported by SpiceIn
# 
# Usage: Intented to be called from main.sh
#   python3 generate_ocn.py syn_out/LVT24_25C LVT24
# # ---------------------------------------------------------------------------

import sys
import time
import pandas as pd
import os
import numpy as np

def write_ocn():
    ocean_file = dir_path + '/' + tech + "_cell_biasing_testbench.ocn"
    result_file = "./results/" + tech +"_cell_biasing_testbench_1.csv"
    maestro = "maestro_top_" + current_time

    original_stdout = sys.stdout # Save a reference to the original standard output
    with open(ocean_file, 'w') as f:
        sys.stdout = f # Change the standard output to the file we created.
        print(';Script generated by generate_ocn.py')
        print(';====================Set to Maestro mode explorer =============================')
        print('ocnSetXLMode("explorer")')
        print('ocnxlProjectDir( "/my_path/work/virtuoso" )')
        print('ocnxlTargetCellView( "'+testbench+'" "top" "'+maestro+'" )')
        print('ocnxlResultsLocation( "" )')
        print('ocnxlHistoryPrefix("biasing")')
        print('ocnxlSimResultsLocation( "" )')
        print('ocnxlMaxJobFail( 20 )')
        print('')
        print(';====================== Tests setup ============================================')
        print('')
        print(';---------- Test "'+testbench+'_top_1" ------------- ')
        print('ocnxlBeginTest("'+testbench+'_top_1")')
        print('simulator( \'spectre )')
        print('design( "'+testbench+'" "top" "schematic")')
        print('modelFile( ')
        print(')')
        print('analysis(\'tran ?stop "'+sim_stop+'\"  ?errpreset "conservative"  )')
        print('desVar(	  "vdd" ' + vdd +	' )')
        print('desVar(	  "vnw_n" 0	)')
        print('desVar(	  "vpw_p" 0	)')
        print('desVar(	  "period" 1u )')
        print('envOption(')
        print('	\'analysisOrder  list("pz" "dcmatch" "stb" "tran" "envlp" "ac" "dc" "lf" "noise" "xf" "sp" "pss" "pac" "pstb" "pnoise" "pxf" "psp" "qpss" "qpac" "qpnoise" "qpxf" "qpsp" "hb" "hbac" "hbstb" "hbnoise" "hbxf" "sens" "acmatch") ')
        print(')')
        print('saveOption( ?infoOptions list(list("modelParameter" "models" "rawfile" "" "" "" t) list("element" "inst" "rawfile" "" "" "" t) list("outputParameter" "output" "rawfile" "" "" "" t) list("designParamVals" "parameters" "rawfile" "" "" "" t) list("primitives" "primitives" "rawfile" "" "" "" t) list("subckts" "subckts" "rawfile" "" "" "" t) list("asserts" "assert" "rawfile" "" "" "" nil) list("extremeinfo" "all" "logfile" "" "yes" "" nil) list("allcap" "allcap" "file" "" "" "" nil) list("<Click_To_Add>" "none" "rawfile" "" "" "" nil) ) )')
        print('save( \'v "/VIN" "/INV_Z" "/NAND_Z" "/NOR_Z" )')
        print('temp( '+str(temp)+' ) ')
        print('ocnxlOutputSignal( "/VIN" ?plot t ?save t)')
        print('ocnxlOutputSignal( "/INV_Z" ?plot t ?save t)')
        print('ocnxlOutputSignal( "/NAND_Z" ?plot t ?save t)')
        print('ocnxlOutputSignal( "/NOR_Z" ?plot t ?save t)')
        print('ocnxlOutputExpr( "dutyCycle(clip(VT(\\"/VIN\\") (lastVal(VT(\\"/VIN\\")) / 2) lastVal(VT(\\"/VIN\\"))) ?mode \\"user\\" ?threshold (VAR(\\"vdd\\") / 2) ?xName \\"time\\" ?outputType \\"average\\")" ?name "IN_DC" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "riseTime(VT(\\"/VIN\\") (VAR(\\"period\\") / 2) t VAR(\\"period\\") t 10 90)" ?name "IN_rise" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "fallTime(VT(\\"/VIN\\") VAR(\\"period\\") t ((3 * VAR(\\"period\\")) / 2) t 10 90)" ?name "IN_fall" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "riseTime(VT(\\"/INV_Z\\") (VAR(\\"period\\") / 2) t VAR(\\"period\\") t 10 90)" ?name "INV_rise" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "fallTime(VT(\\"/INV_Z\\") VAR(\\"period\\") t ((3 * VAR(\\"period\\")) / 2) t 10 90)" ?name "INV_fall" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "dutyCycle(clip(VT(\\"/INV_Z\\") (lastVal(VT(\\"/INV_Z\\")) / 2) lastVal(VT(\\"/INV_Z\\"))) ?mode \\"user\\" ?threshold (VAR(\\"vdd\\") / 2) ?xName \\"time\\" ?outputType \\"average\\")" ?name "INV_DC" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "riseTime(VT(\\"/NAND_Z\\") (VAR(\\"period\\") / 2) t VAR(\\"period\\") t 10 90)" ?name "NAND_rise" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "fallTime(VT(\\"/NAND_Z\\") VAR(\\"period\\") t ((3 * VAR(\\"period\\")) / 2) t 10 90)" ?name "NAND_fall" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "dutyCycle(clip(VT(\\"/NAND_Z\\") (lastVal(VT(\\"/NAND_Z\\")) / 2) lastVal(VT(\\"/NAND_Z\\"))) ?mode \\"user\\" ?threshold (VAR(\\"vdd\\") / 2) ?xName \\"time\\" ?outputType \\"average\\")" ?name "NAND_DC" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "riseTime(VT(\\"/NOR_Z\\") (VAR(\\"period\\") / 2) t VAR(\\"period\\") t 10 90)" ?name "NOR_rise" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "fallTime(VT(\\"/NOR_Z\\") VAR(\\"period\\") t ((3 * VAR(\\"period\\")) / 2) t 10 90)" ?name "NOR_fall" ?plot t ?evalType \'point)')
        print('ocnxlOutputExpr( "dutyCycle(clip(VT(\\"/NOR_Z\\") (lastVal(VT(\\"/NOR_Z\\")) / 2) lastVal(VT(\\"/NOR_Z\\"))) ?mode \\"user\\" ?threshold (VAR(\\"vdd\\") / 2) ?xName \\"time\\" ?outputType \\"average\\")" ?name "NOR_DC" ?plot t ?evalType \'point)')
        print('ocnxlEndTest() ; "'+testbench+'_top_1"')
        print('')
        print(';====================== Sweeps setup ===========================================')
        print('')
        print(';====================== Model Group setup ==========================================')
        print('')
        print(';====================== Corners setup ==========================================')
        
        for vnw_n in np.arange(0, 2.1, 0.1):
            for vpw_p in np.arange(-2, 0.1, 0.1):
                
                print('ocnxlCorner( "wc_'+vdd+'_'+str(round(vnw_n, 1))+'_'+str(str(round(vpw_p, 1)).replace('-', 'm'))+'"')
                print('   \'(')
                print('      ("variable" "vdd" "'+vdd+'")')
                print('      ("variable" "vnw_n" "'+str(round(vnw_n, 1))+'")')
                print('      ("variable" "vpw_p" "'+str(round(vpw_p, 1))+'")')
                print('      ("variable" "temperature" "'+str(temp)+'")')
                print('      ("model" "HERE GOES TRANSISTOR MODEL" ?section "\\"tt\\" \\"ff\\" \\"ss\\"")')
                print('      ("modelGroup" "")')
                print('   )')
                print(')')
        print('')
        print(';====================== Checks and Asserts setup ============================================')
        print('ocnxlPutChecksAsserts(?netlist nil)')
        print('')
        print(';====================== Job setup ==============================================')
        print(') )')
        print('')
        print(';====================== Disabled items =========================================')
        print(';ocnxlDisableCorner("tc_0.80_25") **This disables a corner')
        print('ocnxlSetAllParametersDisabled(t)')
        print('')
        print(';====================== Run Mode Options ======================================')
        print('')
        print(';====================== Starting Point Info ======================================')
        print('')
        print(';====================== Run command ============================================')
        print('printf("*********************************************************************************************\\n")')
        print('printf("Running simulation")')
        print('printf("*********************************************************************************************\\n")')
        print('ocnxlRun( ?mode \'sweepsAndCorners ?nominalCornerEnabled nil ?allCornersEnabled t ?allSweepsEnabled t)')
        print('ocnxlOutputSummary(?exprSummary t ?specSummary t ?detailed t ?wave t)')
        print('ocnxlExportOutputView("'+result_file+'" "Detail")')
        print('ocnxlOpenResults()')
        print('')
        print(';====================== End XL Mode command ===================================')
        print('ocnxlEndXLMode("explorer")')
        print('exit()')
        print('')

        sys.stdout = original_stdout # Reset the standard output to its original value

    print('Simulation file saved in '+ ocean_file)


#dir_path = "./syn_out/SLVT24_25C/"
dir_path = sys.argv[1]
#tech = "LVT24"
tech = sys.argv[2]
testbench = tech + "_Testbench"
temp_str = sys.argv[3]
temp = int(temp_str.replace('m', '-'))

t = time.localtime()
current_time = time.strftime("%H%M%S", t)

vdd = str(sys.argv[4])
sim_stop = '5u'

print('Generating OCN scripts.')
write_ocn()
print('Done...')