import re
import os
import csv
import gzip
import sys

#lib_file_tc = "/library_path/HVT36_tc.lib"
#lib_file_wc = "/library_path/HVT36_wc.lib"

'''
In a text such like this, return value in the middle

"0.0137688, 0.0150271, 0.0173965, 0.0219685, 0.0319864, 0.0548207, 0.106199, 0.197879",\
"0.0152693, 0.0165209, 0.0188896, 0.023457, 0.033496, 0.0563155, 0.107772, 0.199596",\
"0.0182839, 0.0195251, 0.0218886, 0.02647, 0.036507, 0.0593427, 0.11078, 0.202579",\
"0.0237705, 0.0250312, 0.0274031, 0.0319726, 0.042035, 0.0649499, 0.11637, 0.208143",\
"0.0311124, 0.032437, 0.0348371, 0.0394019, 0.049505, 0.0724021, 0.123879, 0.215561",\
"0.0412562, 0.042758, 0.0453693, 0.0499858, 0.0600137, 0.0829246, 0.134398, 0.226131",\
"0.0544402, 0.0562811, 0.0594323, 0.0644088, 0.0744447, 0.0972843, 0.148712, 0.240422",\
"0.0711327, 0.0734402, 0.0771574, 0.0832997, 0.0937454, 0.116406, 0.167798, 0.2595"

returns 0.049505
'''
def get_timing_value(string):
    #split into a list when \ is encounter, remove any \n, space and "
    value_list = string.replace('\n', '').replace(' ', '').replace('"', '').split(",\\")
    # Build list of list
    value_list_list = []
    for row in value_list :
        row_split = row.split(",")
        value_list_list.append(row_split)

    value = value_list_list[int(len(value_list_list)/2)][int(len(value_list_list[0])/2)]
    return value

def get_all_timing_values(library):
    regex_cell = r'\s*cell\s*\((\w+)\)'
    #regex_timing = r'\s*timing\s*\(\)\s*\{[^{]*\s*(?:cell_fall|cell_rise)\s*\(\w+\)\s*\{(?:[^v]*)values\s*\(([^)]*)[^{]*\s*(?:cell_rise|cell_fall)\s*\(\w+\)\s*\{(?:[^v]*)values\s*\(([^)]*)'
    regex_fall = r'\s*related_pin\s*:\s*\"(\w+)\"(?:.|\n)*?\s*cell_fall\s*\(\w+\)\s*\{(?:[^v]*)values\s*\(\s*\\*\s*([^)]*)'
    regex_rise = r'\s*related_pin\s*:\s*\"(\w+)\"(?:.|\n)*?\s*cell_rise\s*\(\w+\)\s*\{(?:[^v]*)values\s*\(\s*\\*\s*([^)]*)'

    # Extract all cells and their attributes from the library by trasversing the curly braces. Saved in data_from_lib
    countBraces = 0
    data = ""
    data_from_lib = []
    if library.endswith('.gz'):
        with gzip.open(library,'rt') as f:
            for line in f:
                if (countBraces == 0) :
                    if (re.search(regex_cell, line) ):
                        cell_name = re.search(regex_cell, line).group(1)
                        countBraces = 1
                else:
                    data += line
                    if ('{' in line) :
                        countBraces +=1 
                    elif ('}' in line) :
                        countBraces -=1 
                        if (countBraces == 0) :         
                            data_from_lib.append([cell_name, data])
                            data = ""
    else:
        with open(library, 'r') as f:
            for line in f:
                if (countBraces == 0) :
                    if (re.search(regex_cell, line) ):
                        cell_name = re.search(regex_cell, line).group(1)
                        countBraces = 1
                else:
                    data += line
                    if ('{' in line) :
                        countBraces +=1 
                    elif ('}' in line) :
                        countBraces -=1 
                        if (countBraces == 0) :         
                            data_from_lib.append([cell_name, data])
                            data = ""


    # Extract timing value for each cell
    list_cell_timing = []
    for cell in data_from_lib:
        cell_name = cell[0]
        cell_attributes = cell[1]
        countBraces = 0
        data = ""
        timing_list = []
        #Extract all timing attributers by trasversing the curly braces
        for line in cell_attributes.splitlines():
                if (countBraces == 0) :
                    if (re.search(r'\s*timing\s*\(\)', line) ):
                        countBraces = 1
                else:
                    data += line
                    if ('{' in line) :
                        countBraces +=1 
                    elif ('}' in line) :
                        countBraces -=1 
                        if (countBraces == 0) :         
                            timing_list.append(data)
                            data = ""
        
        pin_results = []
        for timing in timing_list:
            result_fall = re.findall(regex_fall, timing)
            result_rise = re.findall(regex_rise, timing)
            
            #Go to next if no timing attributes
            if(not result_fall and not result_rise):
                continue
            
            #If both exist, take the sum
            elif (result_fall and result_rise):
                related_pin = result_fall[0][0]
                related_pin_r = result_rise[0][0]
                #Making sure they are the same pin. They should be
                if (related_pin == related_pin_r):
                    timing_matrix_f = result_fall[0][1]
                    timing_matrix_r = result_rise[0][1]
                    cell_value_f = get_timing_value(timing_matrix_f)
                    cell_value_r = get_timing_value(timing_matrix_r)
                    cell_value = float(cell_value_f) + float(cell_value_r)
                    # rise-fall / (rise+fall)/2
                    timing_diff = 100*(float(cell_value_r) - float(cell_value_f))/((float(cell_value_r) + float(cell_value_f))/2)
                    
            elif(not result_fall):
                related_pin = result_rise[0][0]
                timing_matrix_r = result_rise[0][1]
                cell_value = float(get_timing_value(timing_matrix_r))
            
            elif(not result_rise):
                related_pin = result_fall[0][0]
                timing_matrix_f = result_fall[0][1]
                cell_value = float(get_timing_value(timing_matrix_f))

            pin_results.append([related_pin,cell_value,timing_diff])
        list_cell_timing.append([cell_name,pin_results])
    
    return list_cell_timing


#********************************************************************************************
threshold = int(sys.argv[1])
lib_file_tc = sys.argv[2]
lib_file_wc = sys.argv[3]

# Get timing for typical and worst case
print("Extracting data from typical case lib")
tc_value = get_all_timing_values(lib_file_tc)
print("Extracting data from worst case lib")
wc_value = get_all_timing_values(lib_file_wc)


#Matches LVT 
regex1=r'_([a-zA-Z]+VT[0-9]+)_'
#Matches HVT 
regex2= r'_([a-zA-Z]+[0-9]+[a-zA-Z]+)_TT_0P'

#Extract technology name from file
path, filename = os.path.split(lib_file_tc)
if (re.search(regex1, filename) ):
    TECH_CHAN = re.search(regex1, filename).group(1)
elif (re.search(regex2, filename) ):
    TECH_CHAN = re.search(regex2, filename).group(1)
else:
    TECH_CHAN = ""

cell_time_scaling = []
#Go through all cells in Typical case
for cell_tc in tc_value:
    cell_name = cell_tc[0]
    pin_list = cell_tc[1]
    worst_ratio = 0
    worst_diff = 0
    #Go through all cell in worst case
    for cell_wc in wc_value:
        #If they are the same cell
        if (cell_name == cell_wc[0]):
            for (pin,pin_wc) in zip(pin_list, cell_wc[1]):
                if (pin[0] == pin_wc[0]):
                    timing_ratio = pin_wc[1]/pin[1]
                    if (worst_ratio < timing_ratio ):
                        worst_ratio = timing_ratio
                    
                    if (abs(worst_diff) < abs(pin_wc[2])):
                        worst_diff = pin_wc[2]                       

            cell_time_scaling.append([cell_name,worst_ratio,worst_diff])

# Order from worst to better
cell_time_scaling.sort(reverse=True,key=lambda x:x[1])

csv_filename = TECH_CHAN + "_time_scaling.csv"
# Save file
with open(csv_filename, "w", newline="") as f:
    writer = csv.writer(f)
    writer.writerows(cell_time_scaling)


dont_touch_list = ['DF']

cell_time_scaling_new = []
#Build new list NOT containing any cell in the dont_touch_list
for cell in cell_time_scaling:
    found = False
    for i in dont_touch_list:
        if (i in cell[0]):
            found = True
            break
    if (found == False):
        cell_time_scaling_new.append(cell)

num_cell_to_exclude =  int((threshold/100)*len(cell_time_scaling))
#If the numbers of cells to be excluded is greater that the actual number of available cells:
if(num_cell_to_exclude > len(cell_time_scaling_new) ):
    num_cell_to_exclude = 0

tcl_filename = TECH_CHAN + "_exclude_cells_"+str(threshold)+".tcl"
original_stdout = sys.stdout # Save a reference to the original standard output
with open(tcl_filename, 'w') as f:
    sys.stdout = f # Change the standard output to the file we created.
    print('# ####################################################################')
    print('')
    print('# Script created by extract_timing_lib.py')
    print('# Excluding ' + str(threshold)+ '% of cells')
    print('')
    print('# ####################################################################')
    print('')
    print('set sdc_version 2.1')
    print('')
    for i in range(num_cell_to_exclude):
        cell = cell_time_scaling_new[i][0]
        print('set_dont_use [get_lib_cells */'+cell+']')
    sys.stdout = original_stdout # Reset the standard output to its original value
    

print("Finished\n")