#! /bin/bash

PATH_LIB=$1
TECH=$2
TEMP=$3
VDD=$4

echo "Generating OCN"
python3 generate_cell_biasing_ocn.py ${PATH_LIB} ${TECH} ${TEMP} ${VDD}

cd /my_path/mep_thesis/virtuoso

echo "Deleting old testbench"
rm -rf ${TECH}_Testbench/top
rm -rf ${TECH}_Testbench/CRITICAL_PATH

echo "Importing netlist to Virtuoso"
spiceIn -netlistFile ${PATH_LIB}/${TECH}_cell_biasing_testbench.spi -outputLib ${TECH}_Testbench -language SPECTRE -refLibList "cmos22fdsoi analogLib" -devMapFile /my_path/mep_thesis/virtuoso/mapping

echo "Simulating"
virtuoso -nograph -restore ${PATH_LIB}/${TECH}_cell_biasing_testbench.ocn

exit