function imageout = removebug(imagein)


image=rgb2gray(imagein);


[mserRegions, mserConnComp] = detectMSERFeatures(image, ...
    'RegionAreaRange',[200 10000],'ThresholdDelta',2);

pixe2remove=cell2mat(mserRegions.PixelList);

imageinR = imagein(:,:,1);
imageinG = imagein(:,:,2); 
imageinB = imagein(:,:,3); 



for i=1:length(pixe2remove)
    imageinR(pixe2remove(i,2),pixe2remove(i,1))=0;
end

for i=1:length(pixe2remove)
    imageinG(pixe2remove(i,2),pixe2remove(i,1))=0;
end

for i=1:length(pixe2remove)
    imageinB(pixe2remove(i,2),pixe2remove(i,1))=0;
end

imageout= cat(3, imageinR, imageinG, imageinB);


figure
imshow(imagein)
hold on
plot(mserRegions, 'showPixelList', true,'showEllipses',false)
title('MSER regions')
hold off


end

