function [SRE_2mat, ROI_SRE] = ROISRE(im,window,overlap)

% Short Run Emphasis (SRE) is a measure of the distribution of short run lengths, 
% with a greater value indicative of shorter run lengths and more fine textural textures.

if max(max(im))<=1
    im=uint8(im*255);
end

a=round(window/2)-1;
wdw=2*a+1;
[r,c]=size(im);
x=zeros(r,c);
count=zeros(r,c);
mask=zeros(r,c);
mask(im>0)=1; 
 
%                    Angle     OFFSET
%                    -----     ------
%                    0          1
%                    45         2
%                    90         3
%                    135        4

Off=1;  %Offset
NL=5; % Number of gray levels
J=1:wdw; %array of j
numROI=0;
idxROI=zeros(r*c,1);

    for i=round(wdw/2):(wdw-overlap):(r-a)
        for  j=round(wdw/2):(wdw-overlap):(c-a)
            if  sum(sum(mask(i-a:i+a,j-a:j+a)))>=wdw*wdw*0.99
                [z,~] = grayrlmatrix(im(i-a:i+a,j-a:j+a),'Offset',Off,'NumLevels',NL,'G',[]);
                y=cell2mat(z);
                x(i-a:i+a,j-a:j+a) = x(i-a:i+a,j-a:j+a) + double(sum(sum(y)./(J.^2))/sum(y,'all'));
                row=repmat((i-a:i+a),1,wdw);
                col2reshape=repmat((j-a:j+a),wdw,1);
                col=reshape(col2reshape,1,wdw*wdw);
                idx=sub2ind(size(im),row,col);
                count(idx)=count(idx)+1;
                numROI=numROI+1;
                idxROI(numROI)=sub2ind(size(im),i,j);  
            end
        end
    end
    
    SRE_2mat=x./count;
    SRE_2mat(isnan(SRE_2mat))=0;
    SRE_2mat(1:a,:)=0; SRE_2mat(r-a+1:r,:)=0;SRE_2mat(:,1:a)=0; SRE_2mat(:,c-a+1:c)=0;
    idxROI=idxROI(1:numROI);
    
    ROI_SRE=[idxROI,SRE_2mat(idxROI)];
% 	ROI_SRE=sum(sum(SRE_2mat))/sum(sum(SRE_2mat>0)); %average of all pixels

end



