function [RP_2mat, ROI_RP] = ROIRP(im,window,overlap)

% Run Length Non-Uniformity (RLN) measures the similarity of run lengths throughout the image,  
% with a lower value indicating more homogeneity among run lengths in the image.

if max(max(im))<=1
    im=uint8(im*255);
end

a=round(window/2)-1;
wdw=2*a+1;
[r,c]=size(im);       
x=zeros(r,c);
count=zeros(r,c);
mask=zeros(r,c);
mask(im>0)=1; 
 
%                    Angle     OFFSET
%                    -----     ------
%                    0          1
%                    45         2
%                    90         3
%                    135        4

Off=1;  %Offset
NL=5; % Number of gray levels
numROI=0;
idxROI=zeros(r*c,1);

    for i=round(wdw/2):(wdw-overlap):(r-a)
        for  j=round(wdw/2):(wdw-overlap):(c-a)
            if  sum(sum(mask(i-a:i+a,j-a:j+a)))>=wdw*wdw*0.99
                [z,~] = grayrlmatrix(im(i-a:i+a,j-a:j+a),'Offset',Off,'NumLevels',NL,'G',[]);
                y=cell2mat(z);
                x(i-a:i+a,j-a:j+a) = x(i-a:i+a,j-a:j+a) + double(sum(y,'all')/wdw*NL);
                row=repmat((i-a:i+a),1,wdw);
                col2reshape=repmat((j-a:j+a),wdw,1);
                col=reshape(col2reshape,1,wdw*wdw);
                idx=sub2ind(size(im),row,col);
                count(idx)=count(idx)+1;
                numROI=numROI+1;
                idxROI(numROI)=sub2ind(size(im),i,j);  
            end
        end
    end
    
    RP_2mat=x./count;
    RP_2mat(isnan(RP_2mat))=0;
    RP_2mat(1:a,:)=0; RP_2mat(r-a+1:r,:)=0;RP_2mat(:,1:a)=0; RP_2mat(:,c-a+1:c)=0;
    idxROI=idxROI(1:numROI);
    
    ROI_RP=[idxROI,RP_2mat(idxROI)];
% 	ROI_RP=sum(sum(RP_2mat))/sum(sum(RP_2mat>0)); %average of all pixels

end




