function [LGLRE_2mat, ROI_LGLRE] = ROILGLRE(im,window,overlap)

% Low Gray Level Run Emphasis (LGLRE) measures the distribution of low gray-level values,   
% with a higher value indicating a greater concentration of low gray-level values in the image.

if max(max(im))<=1
    im=uint8(im*255);
end

a=round(window/2)-1;
wdw=2*a+1;
[r,c]=size(im);
x=zeros(r,c);
count=zeros(r,c);
mask=zeros(r,c);
mask(im>0)=1; 
 
%                    Angle     OFFSET
%                    -----     ------
%                    0          1
%                    45         2
%                    90         3
%                    135        4

Off=1;  %Offset
NL=5; % Number of gray levels
I=1:NL; %array of i
numROI=0;
idxROI=zeros(r*c,1);

    for i=round(wdw/2):(wdw-overlap):(r-a)
        for  j=round(wdw/2):(wdw-overlap):(c-a)
            if  sum(sum(mask(i-a:i+a,j-a:j+a)))>=wdw*wdw*0.99
                [z,~] = grayrlmatrix(im(i-a:i+a,j-a:j+a),'Offset',Off,'NumLevels',NL,'G',[]);
                y=cell2mat(z);
                x(i-a:i+a,j-a:j+a) = x(i-a:i+a,j-a:j+a) + double(sum(sum(y')./(I.^2))/sum(y,'all'));
                row=repmat((i-a:i+a),1,wdw);
                col2reshape=repmat((j-a:j+a),wdw,1);
                col=reshape(col2reshape,1,wdw*wdw);
                idx=sub2ind(size(im),row,col);
                count(idx)=count(idx)+1;
                numROI=numROI+1;
                idxROI(numROI)=sub2ind(size(im),i,j);  
            end
        end
    end
    
    LGLRE_2mat=x./count;
    LGLRE_2mat(isnan(LGLRE_2mat))=0;
    LGLRE_2mat(1:a,:)=0; LGLRE_2mat(r-a+1:r,:)=0;LGLRE_2mat(:,1:a)=0; LGLRE_2mat(:,c-a+1:c)=0;
    idxROI=idxROI(1:numROI);
    
    ROI_LGLRE=[idxROI,LGLRE_2mat(idxROI)];
% 	ROI_LGLRE=sum(sum(LGLRE_2mat))/sum(sum(LGLRE_2mat>0)); %average of all pixels

end








