function [output] = MetaplasiaDetector(image_RGB)


imnotext=removetext(image_RGB);
imnohole=removehole(imnotext,4);
imout=removewhite(imnohole,6);

% imshow(imout)

image_to_standardize=double(rgb2gray(imout));

%Standardizzazione

datasetfeat=load('datasetfeat.mat');

media=datasetfeat.standardization.mean;
standard=datasetfeat.standardization.std;

image_to_normalize=(image_to_standardize-media)/standard;

%Normalizzazione

massimo=datasetfeat.normalization.max;
minimo=datasetfeat.normalization.min;


image_to_normalize(1,1)=minimo;
image_to_normalize(1,2)=massimo;

image_rescaled=rescale(image_to_normalize);
image_rescaled(1,1)=image_rescaled(1,3);
image_rescaled(1,2)=image_rescaled(1,3);




%%                         Edge Detection



hxs = [-1 0 1;-2 0 2;-1 0 1];
hys = [-1 -2 -1; 0 0 0; 1 2 1];


xg=imfilter(image_rescaled,hxs,'circular');    
yg=imfilter(image_rescaled,hys,'circular');
xyg=xg+yg; gradient=image_rescaled+xyg; mask=image_rescaled; mask(mask>0)=1;
gradient(gradient<=0)=1/255; gradient(gradient>1)=1;
edged=mask.*gradient;
image_to_extract=rescale(edged);    




%%                        FeatureExtractrion   



contrast=[0 0];  % max and min of all features
correlation=[0 0];
energy=[0 0];
homogeneity=[0 0];
mean=[0 0];
median=[0 0];
var=[0 0];
std=[0 0];
rms=[0 0];
uniform=[0 0];
skew=[0 0];
kurt=[0 0];
perc10=[0 0];
perc90=[0 0];
interquart=[0 0];
GLN=[0 0];
GLNN=[0 0];
HGLRE=[0 0];
LGLRE=[0 0];
LRE=[0 0];
LRHGLE=[0 0];
LRLGLE=[0 0];
MAD=[0 0];
RLN=[0 0];
RLNN=[0 0];
RP=[0 0];
SRE=[0 0];
SRHGLE=[0 0];
SRLGLE=[0 0];
fmax=[0 0];
fkurt=[0 0];
fbandwidth=[0 0];


rangefeatures=load('rangefeatures.mat');

feat_max=rangefeatures.max;
feat_min=rangefeatures.min;


warning off


[~, contrasti]=GLCMcontr(image_to_extract,50,20);
contrast=[contrast; contrasti];
[~, correlationi]=GLCMcorrel(image_to_extract,50,20);
correlation=[correlation; correlationi];    
[~, energyi]=GLCMener(image_to_extract,50,20);
energy=[energy; energyi];
[~, homogeneityi]=GLCMhomog(image_to_extract,50,20);
homogeneity=[homogeneity; homogeneityi];
[~, meani]=ROImean(image_to_extract,50,20);
mean=[mean; meani];
[~, mediani]=ROImedian(image_to_extract,50,20);
median=[median; mediani];
[~, vari]=ROIvar(image_to_extract,50,20);
var=[var; vari];
[~, stdi]=ROIstd(image_to_extract,50,20);
std=[std; stdi];   
[~, interquarti]=ROIinterquart(image_to_extract,50,20);
interquart=[interquart; interquarti];
[~, perc10i]=ROIperc10(image_to_extract,50,20);
perc10=[perc10; perc10i];
[~, perc90i]=ROIperc90(image_to_extract,50,20);
perc90=[perc90; perc90i]; 
[~, rmsi]=ROIrms(image_to_extract,50,20);
rms=[rms; rmsi];
[~,uniformi]=ROIuniform(image_to_extract,50,20);
uniform=[uniform; uniformi];
[~, skewi]=ROIskew(image_to_extract,50,20);
skew=[skew; skewi];
[~, kurti]=ROIkurt(image_to_extract,50,20);
kurt=[kurt; kurti]; 
[~, GLNi]=ROIGLN(image_to_extract,50,20);
GLN=[GLN; GLNi];
[~,GLNNi]=ROIGLNN(image_to_extract,50,20);
GLNN=[GLNN; GLNNi];
[~, HGLREi]=ROIHGLRE(image_to_extract,50,20);
HGLRE=[HGLRE; HGLREi];
[~, LGLREi]=ROILGLRE(image_to_extract,50,20);
LGLRE=[LGLRE; LGLREi]; 
[~, LREi]=ROILRE(image_to_extract,50,20);
LRE=[LRE; LREi];
[~, LRHGLEi]=ROILRHGLE(image_to_extract,50,20);
LRHGLE=[LRHGLE; LRHGLEi];
[~, LRLGLEi]=ROILRLGLE(image_to_extract,50,20);
LRLGLE=[LRLGLE; LRLGLEi];
[~, MADi]=ROIMAD(image_to_extract,50,20);
MAD=[MAD; MADi]; 
[~, RLNi]=ROIRLN(image_to_extract,50,20);
RLN=[RLN; RLNi]; 
[~,  RLNNi]=ROIRLNN(image_to_extract,50,20);
RLNN=[RLNN; RLNNi];
[~,  RPi]=ROIRP(image_to_extract,50,20);
RP=[RP; RPi];
[~,  SREi]=ROISRE(image_to_extract,50,20);
SRE=[SRE; SREi];
[~,  SRHGLEi]=ROISRHGLE(image_to_extract,50,20);
SRHGLE=[SRHGLE ;SRHGLEi]; 
[~,  SRLGLEi]=ROISRLGLE(image_to_extract,50,20);
SRLGLE=[SRLGLE; SRLGLEi]; 
[~,  fmaxi]=ROIfmax(image_to_extract,50,20);
fmax=[fmax; fmaxi];
[~,  fkurti]=ROIfkurt(image_to_extract,50,20);
fkurt=[fkurt; fkurti];
[~, fbandwidthi]=ROIbandwidth(image_to_extract,50,20);
fbandwidth=[fbandwidth; fbandwidthi];





features=[(contrast(:,2)),(correlation(:,2)),(energy(:,2)),(homogeneity(:,2)),...
(mean(:,2)),(median(:,2)),(var(:,2)),(std(:,2)),(rms(:,2)),(uniform(:,2)),...
(skew(:,2)),(kurt(:,2)),(perc10(:,2)),(perc90(:,2)),(interquart(:,2)),...
(GLN(:,2)),(GLNN(:,2)),(HGLRE(:,2)),(LGLRE(:,2)),(LRE(:,2)),(LRHGLE(:,2)),(LRLGLE(:,2)),(MAD(:,2)),...
(RLN(:,2)),(RLNN(:,2)),(RP(:,2)),(SRE(:,2)),(SRHGLE(:,2)),(SRLGLE(:,2)),(fmax(:,2)),(fkurt(:,2)),(fbandwidth(:,2))];


features(1,:)=[];   % remove zeros row

features=[feat_min;feat_max;features];


features = rescale(features,'InputMin',feat_min,'InputMax',feat_max);

features(1:2,:)=[];  %remove max and min

ROIs=contrast(2:end,1);  %ROIs array


clearvars -except ROIs features imout image_to_standardize


%%   Valuta immagine


Mdl=load('RandomForest.mat');

Y_preds = Mdl.random_forest.predictFcn(features);


wdw=50;
overlap=20;
index=nonzeros(ROIs.*(Y_preds));

mask= MaskReturn(image_to_standardize,wdw,overlap,index);

fig=figure('visible','off');
imshow(mask)

image(imout)
axis image
hold on

im=image(mask);
im.AlphaData = max(mask,[],3)*0.35;   

saveas(fig,'temp.png');


hold off
close all


I = imread('temp.png');
I=I(69:806,172:1101,:);
delete temp.png

score=(sum(sum(rgb2gray(mask)>0)))/(sum(sum(image_to_standardize>0))*0.2);
percentage=(sum(sum(rgb2gray(mask)>0)))/(sum(sum(image_to_standardize>0)))*100;


if score >=1
    score=100;
end

formatSpec = 'Pathological ROIs percentage: %.2f%%';
str = sprintf(formatSpec,percentage);
position = [525  5]; 

if score > 0.70
    box_color = {'red'};
    RGB = insertText(I,position,str,'FontSize',22,'BoxColor',...
    box_color,'BoxOpacity',0.90,'TextColor','black');

elseif score <= 0.70 && score > 0.20
    box_color = [255 165 0];
    RGB = insertText(I,position,str,'FontSize',22,'BoxColor',...
    box_color,'BoxOpacity',0.90,'TextColor','black');

elseif score == 0.00
    box_color = {'green'};
    RGB = insertText(I,position,str,'FontSize',22,'BoxColor',...
    box_color,'BoxOpacity',0.90,'TextColor','black');
else
    box_color = {'yellow'};
	RGB = insertText(I,position,str,'FontSize',22,'BoxColor',...
    box_color,'BoxOpacity',0.90,'TextColor','black');

end


figure('visible','off','numbertitle', 'off','Name','Pathological ROIs and Disease Score');
imshow(RGB)
title('Pathological ROIs and Disease Score');

output=RGB;

beep
end

