function htmap= MaskReturn(im,wdws,overlap,index)


    a=round(wdws/2)-1;
    wdw=2*a+1;
    [r,c]=size(im);
    x=zeros(r,c);
    majority=zeros(r,c);
    majority(im>0)=1; 
    [index_x,index_y]=ind2sub([r,c],index);
    mask_black=zeros(r,c);


	%DB scan
    
    index_yx = [index_y,index_x];
    
    if isempty(index_yx)==0
    
        idx_DB = dbscan(index_yx,sqrt((wdw-overlap)^2+(wdw-overlap)^2),9);
        index(idx_DB<0)=[];
        [index_i,index_j]=ind2sub([r,c],index);
        
        for i=1:length(index)

            mask_black(index_i(i)-a:index_i(i)+a,index_j(i)-a:index_j(i)+a)= mask_black(index_i(i)-a:index_i(i)+a,index_j(i)-a:index_j(i)+a)+1;

        end



        for i=round(wdw/2):(wdw-overlap):(r-a)
            for  j=round(wdw/2):(wdw-overlap):(c-a)
                if  sum(sum(majority(i-a:i+a,j-a:j+a)))>=wdw*wdw*0.99
                    x(i-a:i+a,j-a:j+a) = x(i-a:i+a,j-a:j+a) + 1;
                end
            end
        end

        x(isnan(x))=0;    %remove nan
        majority=mask_black./x;
        majority(majority>1)=0;    %remove inf
        majority(isnan(majority))=0; %remove nan (due 0/0)



        %heatmap

        majority0=zeros(r,c);


        majorityR_LY=majority0;
        majorityR_LY(majority==0.25)=1;
        majorityG_LY=majority0;            %light yellow
        majorityG_LY(majority==0.25)=0.9882;
        majorityB_LY=majority0;
        majorityB_LY(majority==0.25)=0.7882;  

        majorityR_Y=majority0;
        majorityR_Y(majority==0.50)=1;
        majorityG_Y=majority0;            %yellow
        majorityG_Y(majority==0.50)=1;
        majorityB_Y=majority0;
        majorityB_Y(majority==0.50)=0;

        majorityR_O=majority0;
        majorityR_O(majority==0.75)=1;
        majorityG_O=majority0;            %orange
        majorityG_O(majority==0.75)=0.6471;
        majorityB_O=majority0;
        majorityB_O(majority==0.75)=0;

        majorityR_R=majority0;
        majorityR_R(majority==1)=1;
        majorityG_R=majority0;            %red
        majorityG_R(majority==1)=0;
        majorityB_R=majority0;
        majorityB_R(majority==1)=0;

        majorityR= majorityR_LY + majorityR_Y+ majorityR_O + majorityR_R;
        majorityG= majorityG_LY + majorityG_Y+ majorityG_O + majorityG_R;
        majorityB= majorityB_LY + majorityB_Y+ majorityB_O+ majorityB_R;

        htmap=cat(3, majorityR, majorityG, majorityB);
    else
        
        htmap=cat(3, zeros(r,c), zeros(r,c),zeros(r,c));
        
    end

    
end

