function [contr_2mat,contr] = GLCMcontr(im,window,overlap)

if max(max(im))<=1
    im=uint8(im*255);
end


a=round(window/2)-1;
wdw=2*a+1;
[r,c]=size(im);
x=zeros(r,c);
count=zeros(r,c);
mask=zeros(r,c);
mask(im>0)=1; 
numROI=0;
idxROI=zeros(r*c,1);

    for i=round(wdw/2):(wdw-overlap):(r-a)
        for  j=round(wdw/2):(wdw-overlap):(c-a)
            if  sum(sum(mask(i-a:i+a,j-a:j+a)))>=wdw*wdw*0.99
                ROI=im(i-a:i+a,j-a:j+a); ROI(isnan(ROI))=0;
                glcm = graycomatrix(ROI);
                x(i-a:i+a,j-a:j+a) = x(i-a:i+a,j-a:j+a) + cell2mat(struct2cell(graycoprops(glcm,'contrast')));
                row=repmat((i-a:i+a),1,wdw);
                col2reshape=repmat((j-a:j+a),wdw,1);
                col=reshape(col2reshape,1,wdw*wdw);
                idx=sub2ind(size(im),row,col);
                count(idx)=count(idx)+1;
                numROI=numROI+1;
                idxROI(numROI)=sub2ind(size(im),i,j);
            end
        end
    end
    
    contr_2mat=x./count;
    contr_2mat(isnan(contr_2mat))=0;
    contr_2mat(1:a,:)=0; contr_2mat(r-a+1:r,:)=0;contr_2mat(:,1:a)=0; contr_2mat(:,c-a+1:c)=0;
    idxROI=idxROI(1:numROI);
    
    contr=[idxROI,contr_2mat(idxROI)];
    
    

    
%     contr=sum(sum(contr_2mat))/sum(sum(contr_2mat>0)); %average of all pixels

end

