#########################################################################################
# Alessandro Bugliarelli 2023
# JLNT TCAD modeling
# PMOS AC CAPACITANCE EXTRACTION - 20 NM DEVICE
#########################################################################################
Device PMOS {
	File {
		Grid		= "jlnt_pmos_msh.tdr"
		Plot		= "jlnt_pmos"
		Current		= "jlnt_pmos"
		Parameter	= "jlnt_pmos.par"
	}

	Electrode {
		{ name="Source"    Voltage=0.0 }
		{ name="Drain"     Voltage=0.0 DistResist = SchottkyResist }
		{ name="Gate"      Voltage=0.0 }
	}

	Physics{
		Fermi
		Mobility( DopingDep HighFieldSaturation ( ParameterSetName = "myHighField" ) Enormal )
		EffectiveIntrinsicDensity( Bennett )
		Recombination(
		SRH( DopingDep )
#		Band2Band (
#			Model = Hurkx
#			DensityCorrection = Local 
#			ParameterSetName = ("myBTBT") )
		)
		eQuantumPotential
		hQuantumPotential
	}

	Physics(MaterialInterface = "Silicon/SiO2"){
		Traps(
			Acceptor Level EnergyMid=-0.3 fromMidBandGap 
			Conc=4.0e11 eXsection=1e-14  hXsection=1e-14
		)
	}
}

Math{
	Extrapolate
	RelErrControl
#	Digits=4
#  	Notdamped=50
#  	Iterations=24
#  	Transient=BE
#  	Method=Blocked
#  	SubMethod=ParDiSo
}

Plot{
	NonLocal
	eDensity hDensity
	eCurrent hCurrent
	TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
	eMobility hMobility
	eVelocity hVelocity
	eEnormal hEnormal
	ElectricField/Vector Potential SpaceCharge
	eQuasiFermi hQuasiFermi
	Potential Doping SpaceCharge
	SRH Auger 
	AvalancheGeneration
	DonorConcentration AcceptorConcentration
	Doping
	eGradQuasiFermi/Vector hGradQuasiFermi/Vector
	eEparallel hEparalllel
	BandGap 
	BandGapNarrowing
	Affinity
	ConductionBand ValenceBand
	eQuantumPotential 
	hQuantumPotential
}

File {
	Output = "@log@"
	ACExtract = "@acplot@"
}

System {
	Vsource_pset vd ( d 0 ) { dc = 0.0 }
	Vsource_pset vg ( g 0 ) { dc = 0.0 }
	Vsource_pset vs ( s 0 ) { dc = 0.0 }

	PMOS pmos ( "Drain" = d "Gate" = g "Source" = s )
}

Solve {  
	NewCurrentPrefix="init"
	Coupled(Iterations=100){ Poisson }
	Coupled{ Poisson Electron Hole }

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 
	Goal{ Parameter=vg.dc Voltage= 0.5 } 
	){ Coupled{ Poisson Electron Hole } }

	NewCurrentPrefix=""
	Quasistationary ( InitialStep=0.01 Increment=1.3 MaxStep=0.05 Minstep=1.e-5 
	Goal { Parameter=vg.dc Voltage=-1.6 }
	){ ACCoupled (
	  StartFrequency=1e6 EndFrequency=1e6 NumberOfPoints=1 Decade
	  Node(s d g) Exclude(vs vd vg) 
	  ACCompute (Time = (Range = (0 1)  Intervals = 40))
	){ Poisson Electron Hole }
	}
}

