*** Settings ***
Documentation       Ricerca e confronto soluzioni di viaggio internazionali e nazionali

Library             RPA.Browser.Selenium    auto_close=${FALSE}
Library             RPA.Excel.Files
Library             RPA.Desktop
Library             String
Library             RPA.Excel.Application


*** Variables ***
${n_dipendenti}     20
${row}              0


*** Tasks ***
Ricerca e confronto soluzioni di viaggio internazionale
    Estrazione dati viaggi in aereo
    GoogleFlights
    Kayak
    Booking

Ricerca e confronto soluzioni di viaggio nazionale
    Estrazione dati viaggio in aereo e treno
    Italo
    Frecciarossa
    Booking


*** Keywords ***
Test
    Attach Chrome Browser    9222
    Click Element If Visible    xpath://button[@aria-label="Ignora le informazioni sull'accesso."]

Estrazione dati viaggi in aereo
    RPA.Excel.Files.Open Workbook    Bot.xlsx
    RPA.Excel.Files.Set Active Worksheet    Viaggio Internazionale
    ${dati_input}=    Read Worksheet    header=True    start=1
    Set Global Variable    ${dati_input}
    Close Workbook

Estrazione dati viaggio in aereo e treno
    RPA.Excel.Files.Open Workbook    Bot.xlsx
    RPA.Excel.Files.Set Active Worksheet    Viaggio nazionale
    ${dati_input}=    Read Worksheet    header=True    start=1
    Set Global Variable    ${dati_input}
    Close Workbook

GoogleFlights
    Attach Chrome Browser    9222
    FOR    ${row}    IN RANGE    0    ${n_dipendenti}    1
        Go to    https://www.google.com/travel/flights?hl=it
        sleep    1
        # FILTRI
        Set Selenium Timeout    5
        Click Element
        ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div[1]/div[1]/div/div[1]/div[3]/div/div/div/div[1]
        Sleep    2
        IF    '${dati_input[${row}]['Tipo Viaggio']}' == 'Premium economy'
            Click Element
            ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div[1]/div[1]/div/div[1]/div[3]/div/div/div/div[2]/ul/li[2]
        ELSE
            IF    '${dati_input[${row}]['Tipo Viaggio']}' == 'Economy'
                Click Element
                ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div[1]/div[1]/div/div[1]/div[3]/div/div/div/div[2]/ul/li[1]
            ELSE
                Click Element
                ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div[1]/div[1]/div/div[1]/div[3]/div/div/div/div[2]/ul/li[3]
            END
        END
        # DATI VIAGGIO:PARTENZA, DESTINAZIONE E DATE
        Clear Element Text    xpath://*[@id="i23"]/div[1]/div/div/div[1]/div/div/input
        Sleep    2
        Input Text    xpath://*[@id="i23"]/div[1]/div/div/div[1]/div/div/input    ${dati_input[${row}]['Partenza']}
        Sleep    2
        RPA.Desktop.Press Keys    enter
        Sleep    2
        RPA.Desktop.Press Keys    tab
        Sleep    1
        Type Text    ${dati_input[${row}]['Destinazione']}
        Sleep    2
        RPA.Desktop.Press Keys    Tab
        RPA.Desktop.Press Keys    Tab
        Sleep    2
        RPA.Desktop.Press Keys    Delete
        Type Text    ${dati_input[${row}]['Data partenza']}
        Sleep    3
        IF    '${dati_input[${row}]['Data ritorno']}' == ''
            RPA.Desktop.Press Keys    tab
            RPA.Desktop.Press Keys    enter
        ELSE
            RPA.Desktop.Press Keys    Tab
            Type Text    ${dati_input[${row}]['Data ritorno']}
            Sleep    2
            RPA.Desktop.Press Keys    Tab
            Sleep    3
            RPA.Desktop.Press Keys    Enter
        END
        # SCALO
        Click Element When Visible
        ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div/div[4]/div/div/div[2]/div[1]/div/div[1]/span/button
        IF    ${dati_input[${row}]['Scali']} == 0
            Click Element When Visible    xpath://div[@role="radiogroup"]/div[2]/div
            Sleep    2
            # caso: non ci sono voli per questi filtri
            Click Element
            ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div/div[4]/div/div/div[2]/div[1]/div/div[1]/span/button
            Sleep    3
            Click Element If Visible    xpath://*[contains(text(),'Cerca')]
            Sleep    3
            Click Element If Visible    xpath://*[contains(text(),'Cerca')]
        END
        IF    ${dati_input[${row}]['Scali']} == 1
            Click Element When Visible    xpath://div[@role="radiogroup"]/div[3]/div
            Sleep    2
            # caso: non ci sono voli per questi filtri
            Click Element
            ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div/div[4]/div/div/div[2]/div[1]/div/div[1]/span/button
            Sleep    3
            Click Element If Visible    xpath://*[contains(text(),'Cerca')]
            Sleep    3
            Click Element If Visible    xpath://*[contains(text(),'Cerca')]
        END
        IF    ${dati_input[${row}]['Scali']} == 2
            Click Element When Visible    xpath://div[@role="radiogroup"]/div[4]/div
            Sleep    2
            # caso: non ci sono voli per questi filtri
            Click Element
            ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div[2]/div[1]/div/div[4]/div/div/div[2]/div[1]/div/div[1]/span/button
            Sleep    3
            Click Element If Visible    xpath://*[contains(text(),'Cerca')]
            Sleep    3
            Click Element If Visible    xpath://*[contains(text(),'Cerca')]
        END
        Sleep    2
        # ORDINAMENTO
        Run Keyword And Ignore Error    Click Element When Visible    xpath://span[text()='Ordina per:']
        Sleep    2
        Run Keyword And Ignore Error
        ...    Click Element When Visible
        ...    xpath://ul[@aria-label="Seleziona l'ordinamento."]//span[text()='Prezzo']
        Sleep    5
        Click Element
        ...    xpath:(//ul)[5]/li[1]
        Sleep    5
        IF    '${dati_input[${row}]['Data ritorno']}' != ''
            Click Element
            ...    xpath:(//ul)[5]/li[1]
        END
        Sleep    5
        # ESTRAZIONE INFO
        ${Prezzo_gf}=    RPA.Browser.Selenium.Get Text    xpath://span[contains(@aria-label,'euro')]
        ${Gf_veicolo}=    RPA.Browser.Selenium.Get Text    xpath://div[@class="sSHqwe tPgKwe ogfYpf"]/span
        ${Gf_orario_partenza_andata}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//span[contains(@aria-label,'Ora di partenza')])[2]
        ${Gf_orario_partenza_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//span[contains(@aria-label,'Ora di partenza')])[5]
        ${Gf_durata_partenza}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//div[contains(@aria-label,'Durata totale')])[1]
        ${Gf_durata_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//div[contains(@aria-label,'Durata totale')])[2]
        ${scalo_andata}=    RPA.Browser.Selenium.Get Text
        ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div/div[2]/div[2]/div[3]/div/div[2]/div[1]/div/div/div/div[1]/div[2]/div/div[1]/div/div[2]/div[4]/div[1]/span
        ${scalo_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath://*[@id="yDmH0d"]/c-wiz[2]/div/div[2]/c-wiz/div[1]/c-wiz/div/div[2]/div[2]/div[3]/div/div[2]/div[1]/div/div/div/div[2]/div[2]/div/div[1]/div/div[2]/div[4]/div[1]/span
        Sleep    2
        Scroll Element Into View    xpath:(//span[text()='Continua'])[1]
        Sleep    6
        Click Element    xpath:(//span[text()='Continua'])[1]
        ${handles}=    Get Window Handles
        ${row1}=    Evaluate    ${row}+1
        ${URL_trovato}=    Run Keyword and Return Status    Switch Window    ${handles}[${row1}]
        Sleep    6
        IF    ${URL_trovato} == ${False}
            ${Gf_url}=    Set Variable    Biglietto da prenotare con due compagnie
        ELSE
            ${Gf_url}=    Get Location
            Switch Window    ${handles}[0]
        END
        # SCRITTURA INFO
        ${row'}=    Evaluate    ${row}+2
        RPA.Excel.Application.Open Workbook    Bot.xlsx
        RPA.Excel.Application.Set Active Worksheet    GoogleFlight
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    6    ${Gf_orario_partenza_andata}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    8    ${Gf_orario_partenza_ritorno}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    9    ${Gf_durata_partenza}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    10    ${Gf_durata_ritorno}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    12    ${Prezzo_gf}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    13    ${Gf_veicolo}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    16    ${Gf_url}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    14    ${scalo_andata}
        RPA.Excel.Application.Write To Cells    GoogleFlight    ${row'}    15    ${scalo_ritorno}
        Save Excel
        RPA.Excel.Application.Close Document
    END

Kayak
    Attach Chrome Browser    9222
    FOR    ${row}    IN RANGE    0    ${n_dipendenti}    1
        ${handles}=    Get Window Handles
        Switch Window    ${handles}[0]
        Go To    https://www.kayak.it/flights
        Sleep    2
        # NEL CASO COMPAIANO POPUP DI ACCESSO O COOKIE
        Click Element If Visible
        ...    xpath://*[@class="keel kl kl-override FlightsSearch react react-st wide a11y-focus-outlines wide-fd it_IT horizon"]/div[6]/div/div[3]/div/div/div[2]/div/div/div[1]/button/div[1]
        # INPUT GIA PIENO
        Click Element If Visible    xpath:(//div[@class="vvTc-item-close"]/div)[1]    # clearinput
        Click Element    xpath:(//input[@type='text'])[1]    # clickinput
        Sleep    1
        Input Text    xpath:(//input[@type='text'])[1]    ${dati_input[${row}]['Partenza']}
        Sleep    1
        Click Element When Visible    xpath://li[@role="option"][1]    # primo dell'elenco
        Click Element If Visible    xpath:(//div[@class="vvTc-item-close"]/div)[2]    # clearinput
        Click Element    xpath:(//input[@type='text'])[2]    # clickinput
        Sleep    1
        Input Text    xpath:(//input[@type='text'])[2]    ${dati_input[${row}]['Destinazione']}
        Sleep    1
        Click Element When Visible    xpath://li[@role="option"][1]
        Click Element
        ...    xpath://*[@class="Ui-Searchforms-Flights-Components-FlightSearchForm-container "]/div/div/div/div[1]/div[2]/div/div[4]/div/div/div/div[1]
        FOR    ${index}    IN    5
            Click Element    xpath://button[@aria-label="Mese precedente"]
        END
        ${condition}=    Set Variable    ${False}
        FOR    ${index}    IN RANGE    5
            ${element_exist}=    Run Keyword And Return Status
            ...    Page Should Contain Element
            ...    xpath://*[@id="popover"]/div/div[2]/div/div[2]/div/div[2]/div[1]/div[1]/div[contains(text(),'${dati_input[${row}]['mese partenza']}')][1]
            IF    ${element_exist}
                # CLICCO SUL PRIMO NUMERO CORRISPONDENTE AL "GIORNO PARTENZA" E RESTITUISCO LO STATO
                ${Giorno_trovato}=    Run Keyword And Return Status    Click Element
                ...    xpath:(//div[@class='onx_-days']/*[text()="${dati_input[${row}]['Giorno partenza']}"])[1]
                Sleep    3
                # SE RESTITUISCE FALSE SVUOL DIRE CHE IL NUMERO NON ERA CLICCABILE E NON VISIBILE QUINDI CLICCO IL 2°
                IF    '${Giorno_trovato}' == '${False}'
                    Click Element
                    ...    xpath:(//div[@class='onx_-days']/*[text()="${dati_input[${row}]['Giorno partenza']}"])[2]
                END
                ${condition}=
                ...    Set Variable    ${True}
                Sleep    2
            ELSE
                Sleep    2
                Click Element
                ...    xpath://button[@aria-label='Prossimo mese']
                Sleep    2
            END
            IF    ${condition}    BREAK
        END
        ${condition}=    Set Variable    ${False}
        FOR    ${index}    IN RANGE    5
            ${element_exist}=    Run Keyword And Return Status
            ...    Page Should Contain Element
            ...    xpath://*[@id="popover"]/div/div[2]/div/div[2]/div/div[2]/div[1]/div[1]/div[contains(text(),'${dati_input[${row}]['mese ritorno']}')][1]
            IF    ${element_exist}
                ${Giorno_trovato}=    Run Keyword And Return Status    Click Element
                ...    xpath:(//div[@class='onx_-days']/*[text()="${dati_input[${row}]['Giorno ritorno']}"])[1]
                IF    '${Giorno_trovato}' == '${False}'
                    Click Element
                    ...    xpath:(//div[@class='onx_-days']/*[text()="${dati_input[${row}]['Giorno ritorno']}"])[2]
                END
                ${condition}=
                ...    Set Variable    ${True}
                Sleep    2
            ELSE
                Click Element If Visible
                ...    xpath://button[@aria-label='Prossimo mese']
                Sleep    2
            END
            IF    ${condition}    BREAK
        END

        Click Element
        ...    xpath://*[@class="Ui-Searchforms-Flights-Components-FlightSearchForm-container "]/div/div/div/div[1]/div[2]/div/div[5]/button
        Sleep    3
        ${handles}=    Get Window Handles
        Switch Window    ${handles}[1]
        Sleep    2
        # Definisci criterio Prezzo o Durata
        IF    '${dati_input[${row}]['Criterio']}' == 'Prezzo'
            Click Element
            ...    xpath://*[@class="Ui-Flights-Results-Components-FlightResultsSortOptions-container "]/div/div[1]
        ELSE
            Click Element
            ...    xpath://*[@class="Ui-Flights-Results-Components-FlightResultsSortOptions-container "]/div/div[3]
        END
        # Definisci scalo
        Scroll Element Into View
        ...    xpath://*[@aria-label="Scali"]
        Sleep    2
        IF    '${dati_input[${row}]['Scali']}' == '0'
            Click element
            ...    xpath:(//*[@aria-label="Scali"])[1]/div[2]/div/div[3]/div[1]/div[1]
            Click Element    xpath:(//*[@aria-label="Scali"])[1]/div[2]/div/div[2]/div[1]/div[1]
        END
        IF    ('${dati_input[${row}]['Scali']}' == '1')
            Click Element    xpath:(//*[@aria-label="Scali"])[1]/div[2]/div/div[3]/div[1]/div[1]
        END
        # Definisci veicolo
        Sleep    4
        Scroll Element Into View
        ...    xpath://div[text()='Siti di prenotazione']
        Click Element When Visible
        ...    xpath://div[text()='Siti di prenotazione']
        Click Element When Visible
        ...    xpath://div[text()='Solo compagnie aeree']
        Sleep    2
        # Estrai prezzi
        Sleep    4
        Scroll Element Into View
        ...    xpath:(//div[@class="f8F1-price-text"])[1]
        ${Kayak_Veicolo}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//div[@class="J0g6-operator-text"])[1]
        ${Kayak_Prezzo}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//div[@class="f8F1-price-text"])[1]
        ${Kayak_link}=    Get Location
        # Estrai durata
        ${Kayak_andata_dur}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@class="vmXl vmXl-mod-variant-default"])[2]
        ${Kayak_ritorno_dur}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@class="vmXl vmXl-mod-variant-default"])[4]
        ${Kayak_partenza_andata}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@class="vmXl vmXl-mod-variant-large"]/span)[1]
        ${Kayak_partenza_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@class="vmXl vmXl-mod-variant-large"]/span)[4]
        ${handles}=    Get Window Handles
        Switch Window    ${handles}[0]
        RPA.Browser.Selenium.Close Window
        Sleep    2
        ${row'}=    Evaluate    ${row}+2
        RPA.Excel.Application.Open Workbook    Bot.xlsx
        RPA.Excel.Application.Set Active Worksheet    Kayak
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    6    ${Kayak_partenza_andata}
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    8    ${Kayak_partenza_ritorno}
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    9    ${Kayak_andata_dur}
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    10    ${Kayak_ritorno_dur}
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    12    ${Kayak_Prezzo}
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    13    ${Kayak_Veicolo}
        RPA.Excel.Application.Write To Cells    Kayak    ${row'}    16    ${Kayak_link}
        Save Excel
        RPA.Excel.Application.Close Document
    END

Italo
    Attach Chrome Browser    9222
    FOR    ${row}    IN RANGE    0    ${n_dipendenti}    1
        Go to    https://www.italotreno.it/it
        sleep    1
        Click Element    xpath://*[@id="main-funnel"]/section/div[2]/div/div/div[2]/div/div/div[1]/div[2]
        Input Text
        ...    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[2]/div/div/div[1]/div[2]/div/input
        ...    ${dati_input[${row}]['Partenza']}
        # RPA.Desktop.Press Keys    enter
        RPA.Desktop.Press Keys    down
        RPA.Desktop.Press Keys    enter
        RPA.Desktop.Press Keys    Tab
        Input Text
        ...    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[2]/div/div/div[2]/div[3]/div/input
        ...    ${dati_input[${row}]['Destinazione']}
        RPA.Desktop.Press Keys    down
        RPA.Desktop.Press Keys    enter
        RPA.Desktop.Press Keys    Tab
        Click Element    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[3]/div/div[1]/div/div/div[2]
        Sleep    2
        ${element_exist}=    Run Keyword And Return Status
        ...    Page Should Contain Element
        ...    xpath:(//div[@class="c-pane"])[1]//div[contains(text(),'${dati_input[${row}]['mese partenza']}')]
        ${condition}=    Set Variable    ${False}
        FOR    ${index}    IN RANGE    4
            IF    ${element_exist}
                ${Giorno_trovato}=    Run Keyword And Return Status
                ...    Click Element
                ...    xpath:(//div[text()=${dati_input[${row}]['Giorno partenza']}])[1]
                IF    ${Giorno_trovato} == ${False}
                    Click Element    xpath:(//div[text()=${dati_input[${row}]['Giorno partenza']}])[2]
                END
                ${condition}=    Set Variable    ${True}
            ELSE
                Click Element
                ...    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[3]/div/div[1]/div[2]/div/div[2]/div[3]/div[1]/div[3]
                Sleep    2
                ${element_exist}=    Run Keyword And Return Status
                ...    Page Should Contain Element
                ...    xpath:(//div[@class="c-pane"])[1]//div[contains(text(),'${dati_input[${row}]['mese partenza']}')]
                Log    ${element_exist}
            END
            IF    ${condition}    BREAK
        END
        Sleep    2
        IF    '${dati_input[${row}]['Data ritorno']}' != 'None'
            Click Element    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[3]/div/div[2]/div/div
            Sleep    1
            ${element_exist}=    Run Keyword And Return Status
            ...    Page Should Contain Element
            ...    xpath:(//div[@class="c-pane"])[1]//div[contains(text(),'${dati_input[${row}]['mese ritorno']}')]
            ${condition}=    Set Variable    ${False}
            Sleep    1
            FOR    ${index}    IN RANGE    4
                ${element_exist}=    Run Keyword And Return Status
                ...    Page Should Contain Element
                ...    xpath:(//div[@class="c-pane"])[1]//div[contains(text(),'${dati_input[${row}]['mese ritorno']}')]
                Log    ${element_exist}
                IF    ${element_exist}
                    ${Giorno_trovato}=    Run Keyword And Return Status
                    ...    Click Element
                    ...    xpath:(//div[text()=${dati_input[${row}]['Giorno ritorno']}])[1]
                    IF    ${Giorno_trovato} == ${False}
                        Click Element    xpath:(//div[text()=${dati_input[${row}]['Giorno ritorno']}])[2]
                    END
                    ${condition}=    Set Variable    ${True}
                    ${condition}=    Set Variable    ${True}
                ELSE
                    Click Element
                    ...    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[3]/div/div[2]/div[2]/div/div[2]/div[3]/div[1]/div[3]
                    Sleep    2
                END
                IF    ${condition}    BREAK
            END
        END
        Sleep    1
        Click Element If Visible    xpath://*[@id="cookie-row"]/div/div[2]/button[1]
        # Inserire passeggeri
        Click Element    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[4]/div/div/div/div/div
        Click Element When Visible
        ...    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[4]/div/div[2]/div[2]/div/div/div/div[4]
        Sleep    1
        Click Element    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[4]/div/div/div/div/div
        Click Button    xpath://*[@id="main-funnel"]/section/div[3]/div/div/div[6]/form/div/button
        Sleep    5
        # Estrazione prezzo ritorno (sel)
        IF    '${dati_input[${row}]['Data ritorno']}' != 'None'
            ${Prezzo_italo_andata}=    RPA.Browser.Selenium.Get Text
            ...    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[4]/p/span
            Log    ${Prezzo_italo_andata}
            ${Orario_italo_andata}=    RPA.Browser.Selenium.Get Text
            ...    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[1]/p
            ${Durata_italo_andata}=    RPA.Browser.Selenium.Get Text
            ...    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[3]/div/p
            Click Element    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[4]/a
            Sleep    1
            Sleep    2
            Run Keyword And Ignore Error
            ...    Scroll Element Into View
            ...    xpath:(//label[text()='${Prezzo_italo_andata}'])[1]
            Click Element When Visible    xpath:(//label[text()='${Prezzo_italo_andata}'])[1]
            # sleep    4
            Click Element If Visible    xpath://button[text()='Accetta']
            Run Keyword And Ignore Error    Scroll Element Into View
            ...    xpath://*[@id="BookingGrigliaTreniRestylingBookingSelezioneTrenoAView_ButtonSell"]
            Sleep    5
            Click Element When Visible
            ...    xpath://*[@id="BookingGrigliaTreniRestylingBookingSelezioneTrenoAView_ButtonSell"]
            Sleep    4
            ${Prezzo_italo_ritorno}=    RPA.Browser.Selenium.Get Text
            ...    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[4]/p/span
            Log    ${Prezzo_italo_ritorno}
            ${Orario_italo_ritorno}=    RPA.Browser.Selenium.Get Text
            ...    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[1]/p
            ${Durata_italo_ritorno}=    RPA.Browser.Selenium.Get Text
            ...    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[3]/div/p
            # Salvataggio url
            Click Element    xpath://*[@id="booking-flow"]/div[6]/div[3]/div[1]/div[1]/div[1]/div/div/div[4]
            Sleep    2
            # Scroll Element Into View    xpath:(//label[text()='${Prezzo_italo_ritorno}'])[1]
            Sleep    2
            Run Keyword And Ignore Error
            ...    Scroll Element Into View
            ...    xpath:(//label[text()='${Prezzo_italo_ritorno}'])[1]
            Click Element When Visible    xpath:(//label[text()='${Prezzo_italo_ritorno}'])[1]
            Run Keyword And Ignore Error
            ...    Scroll Element Into View
            ...    xpath://*[@id="BookingGrigliaTreniRestylingBookingSelezioneTrenoRView_ButtonSell"]
            Sleep    4
            Click Element When Visible
            ...    xpath://*[@id="BookingGrigliaTreniRestylingBookingSelezioneTrenoRView_ButtonSell"]
            Sleep    1
            ${Prezzo_italo}=    RPA.Browser.Selenium.Get Text
            ...    xpath://div[@class="box-top-riepilogo__totalAmount_container"]/h3
        END
        RPA.Excel.Files.Open Workbook    Bot.xlsx
        RPA.Excel.Files.Set Active Worksheet    Italo
        ${row+2}=    Evaluate    ${row}+2    # nnn scrivere in prima riga
        RPA.Excel.Files.Set Cell Value    ${row+2}    2    Treno_Italo
        RPA.Excel.Files.Set Cell Value    ${row+2}    3    ${Orario_italo_andata}
        RPA.Excel.Files.Set Cell Value    ${row+2}    4    ${Orario_italo_ritorno}
        RPA.Excel.Files.Set Cell Value    ${row+2}    5    ${Prezzo_italo}
        Save Workbook
        Close Workbook
    END

Frecciarossa
    Attach Chrome Browser    9222
    FOR    ${row}    IN RANGE    0    ${n_dipendenti}    1
        Go to    https://www.trenitalia.com/it.html
        sleep    1
        Click Element If Visible    xpath://*[@id="onetrust-close-btn-container"]/button
        Scroll Element Into View    xpath://*[@id="biglietti_fromNew"]
        Input Text    xpath://*[@id="biglietti_fromNew"]    ${dati_input[${row}]['Partenza']}
        Sleep    1
        RPA.Desktop.Press Keys    enter
        RPA.Desktop.Press Keys    tab    tab
        Sleep    1
        Input Text    xpath://*[@id="biglietti_toNew"]    ${dati_input[${row}]['Destinazione']}

        Sleep    1
        RPA.Desktop.Press Keys    Enter
        RPA.Desktop.Press Keys    Tab
        sleep    1
        RPA.Desktop.Press Keys    Tab
        Sleep    1
        # Inserimento Data
        ${condition}=    Set Variable    ${False}
        FOR    ${index}    IN RANGE    5
            ${element_exist}=    Run Keyword And Return Status
            ...    Page Should Contain Element
            ...    xpath:(//div[@class="ui-datepicker-title"])[1]//span[text()='${dati_input[${row}]['Mese partenza']}']
            Log    ${element_exist}
            IF    ${element_exist}
                Click Element
                ...    xpath://div[@class="ui-datepicker-group ui-datepicker-group-first"]//a[text()=${dati_input[${row}]['Giorno partenza']}]
                ${condition}=    Set Variable    ${True}
            ELSE
                Scroll Element Into View    xpath://*[@id="ui-datepicker-div"]/div[2]/div/a
                Click Element
                ...    xpath://*[@id="ui-datepicker-div"]/div[2]/div/a
                Sleep    2
            END
            IF    ${condition}    BREAK
        END
        Sleep    2
        # Inserisci orario
        Click Element    xpath://input[@id='biglietti_ora_p_but']
        Scroll Element Into View    xpath:(//button[text()="08:00"])[1]
        Click Button    xpath:(//button[text()="08:00"])[1]
        # Inserisci ritorno
        IF    '${dati_input[${row}]['Data ritorno']}' != 'None'
            Click Element    xpath://*[@id="label_ritorno"]
            Sleep    1
            Click Element    xpath://*[@id="biglietti_data_aVISIBLE"]
            ${condition}=    Set Variable    ${False}
            FOR    ${index}    IN RANGE    5
                ${element_exist}=    Run Keyword And Return Status
                ...    Page Should Contain Element
                ...    xpath:(//div[@class="ui-datepicker-title"])[1]//span[text()='${dati_input[${row}]['Mese ritorno']}']
                IF    ${element_exist}
                    Click Element
                    ...    xpath://div[@class="ui-datepicker-group ui-datepicker-group-first"]//a[text()=${dati_input[${row}]['Giorno ritorno']}]
                    ${condition}=    Set Variable    ${True}
                ELSE
                    Scroll Element Into View    xpath://*[@id="ui-datepicker-div"]/div[2]/div/a
                    Click Element
                    ...    xpath://*[@id="ui-datepicker-div"]/div[2]/div/a
                    Sleep    2
                END
                IF    ${condition}    BREAK
            END
            Click Element    xpath://input[@id='biglietti_ora_a_but']
            Sleep    1
            FOR    ${index}    IN RANGE    1
                RPA.Desktop.Press Keys    up
            END
        END
        Click Button    xpath:(//button[text()="17:00"])[2]    # da personalizzare
        Sleep    2
        # Inizio Ricerca
        Click Button    xpath://*[@id="sub-and-carnet"]/button
        # Il bot seleziona 'Frecce'
        Sleep    15
        Click Element When Visible    xpath://button[@title='Principali soluzioni']
        Sleep    2
        Click Element When Visible    xpath:(//ul[@class="dropdown-menu inner show"])[1]/li[2]
        Sleep    15
        # estrazione info andata
        ${Prezzo_trenitalia_andata}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//title2[@class='black text-primary mr-2 mb-0 solution-price-size'])[1]
        ${Durata_trenitalia_andata}=    RPA.Browser.Selenium.Get Text
        ...    (//div[@class='duration text-nowrap']//strong)[1]
        ${Partenza_trenitalia_andata}=    RPA.Browser.Selenium.Get Text
        ...    XPATH:(//*[@class="col-2 time text-nowrap"]/b)[1]
        ${Arrivo_trenitalia_andata}=    RPA.Browser.Selenium.Get Text
        ...    XPATH:(//*[@class="col-2 pl-0 time text-nowrap"]/b)[1]
        Click Element When Visible
        ...    xpath:(//div[@element.ref="solutionCollapseTargetDOM"])[1]
        Wait And Click Button    xpath://*[@id="footer"]/footer/div/div/div/div[2]/button
        Sleep    5
        Click Element If Visible    xpath://*[@id="upsellingDialog"]/div/div/div[3]/button[1]
        Sleep    15
        # Scelta ritorno
        Click Element if Visible    xpath://button[@title='Principali soluzioni']
        Sleep    2
        Click Element if Visible    xpath:(//ul[@class="dropdown-menu inner show"])[1]/li[2]
        Sleep    15
        ${Prezzo_trenitalia_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//title2[@class='black text-primary mr-2 mb-0 solution-price-size'])[1]
        Log    ${Prezzo_trenitalia_ritorno}
        ${Durata_trenitalia_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    (//div[@class='duration text-nowrap']//strong)[1]
        ${Partenza_trenitalia_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@class="col-2 time text-nowrap"]/b)[2]
        ${Arrivo_trenitalia_ritorno}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@class="col-2 pl-0 time text-nowrap"]/b)[2]
        Click Element
        ...    xpath:(//div[@element.ref="solutionCollapseTargetDOM"])[1]
        Click Element When Visible    xpath://*[@id="footer"]/footer/div/div/div/div[2]/button/div
        Sleep    3
        Click Element If Visible    xpath://*[@id="upsellingDialog"]/div/div/div[3]/button[1]
        Sleep    5
        # estrazione totale
        Scroll Element Into View
        ...    xpath://*[@id="main-content"]/div/div/div/div[3]/div/payment/div[1]/div/div[2]/div[1]/hero2
        ${Prezzo_trenitalia}=    RPA.Browser.Selenium.Get Text
        ...    xpath://*[@id="main-content"]/div/div/div/div[3]/div/payment/div[1]/div/div[2]/div[1]/hero2
        # scrittuta su excel
        RPA.Excel.Application.Open Workbook    Bot.xlsx
        RPA.Excel.Application.Set Active Worksheet    Nazionale
        ${row+2}=    Evaluate    ${row}+2    # nnn scrivere in prima riga
        # confronto
        ${Prezzo_trenitalia'}=    Replace String    ${Prezzo_trenitalia}    €    ${EMPTY}
        ${Prezzo_trenitalia"}=    Replace String    ${Prezzo_trenitalia'}    ,    .
        ${Prezzo_italo}=    Read From Cells    Nazionale    ${row+2}    5
        ${Prezzo_italo'}=    Replace String    ${Prezzo_italo}    €    ${EMPTY}
        ${Prezzo_italo"}=    Replace String    ${Prezzo_italo'}    ,    .
        IF    ${Prezzo_italo"} > ${Prezzo_trenitalia"}
            Write To Cells    Nazionale    ${row+2}    2    Trenitalia
            Write To Cells    Nazionale    ${row+2}    5    ${Prezzo_trenitalia"}
            Write To Cells
            ...    Nazionale
            ...    ${row+2}
            ...    3
            ...    "${Partenza_trenitalia_andata}-${Arrivo_trenitalia_andata}"
            Write To Cells
            ...    Nazionale
            ...    ${row+2}
            ...    4
            ...    "${Partenza_trenitalia_ritorno}-${Arrivo_trenitalia_ritorno}"
        END
        Write To Cells    Trenitalia    ${row+2}    2    Trenitalia
        Write To Cells    Trenitalia    ${row+2}    5    ${Prezzo_trenitalia"}
        Write To Cells    Trenitalia    ${row+2}    3    "${Partenza_trenitalia_andata}-${Arrivo_trenitalia_andata}"
        Write To Cells    Trenitalia    ${row+2}    4    "${Partenza_trenitalia_ritorno}-${Arrivo_trenitalia_ritorno}"
        Save Excel
        RPA.Excel.Application.Close Document
    END

Booking
    FOR    ${row}    IN RANGE    0    ${n_dipendenti}    1
        Attach Chrome Browser    9222
        Go To
        ...    https://www.booking.com/index.it.html?label=gen173nr-1BCAEoggI46AdIM1gEaHGIAQGYARS4ARfIAQzYAQHoAQGIAgGoAgO4AsaQlaUGwAIB0gIkZWM4YWI4N2YtYmYwNC00MDE4LTk1NmEtYjdkZjU0ZThhNjBl2AIF4AIB&sid=a60b87f7792af5cd9aca54c7acaf2bd6&keep_landing=1&sb_price_type=total&
        # Accesso e cookie
        Sleep    2
        Click Element If Visible    xpath://*[@id="b2indexPage"]/div[24]/div/div/div/div[1]/div[1]/div/button
        Click Element If Visible    xpath://*[@id="continue-as"]
        Click Element If Visible    xpath://*[@id="onetrust-accept-btn-handler"]
        Click Element If Visible    xpath://button[@aria-label="Ignora le informazioni sull'accesso."]
        # Clear input
        Click Element If Visible
        ...    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[1]/div/div/div[1]/div/div/div[3]
        Click Element
        ...    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[1]/div/div
        Input Text    xpath://*[@id=":Ra9:"]    ${dati_input[${row}]['Destinazione']}
        Click Element    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[2]/div/div[1]
        # For per ritornare al primo mese disponibile
        FOR    ${INDEX}    IN RANGE    6
            ${button1}=    Run Keyword And Return Status
            ...    Page Should Contain Element
            ...    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[1]
            ${button2}=    Run Keyword And Return Status
            ...    Page Should Contain Element
            ...    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[2]
            IF    ${button1} and ${button2}
                Click Element    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[1]
            END
        END
        # Selezione mese e giorno andata
        ${Button}=    Set Variable    ${False}    # Usata per il calendario e le frecce
        ${element_exist}=    Run Keyword And Return Status
        ...    Page Should Contain Element
        ...    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/div/div[1]/h3[contains(text(),'${dati_input[${row}]['mese partenza']}')]
        IF    ${element_exist}
            Click Element    xpath://span[text()='${dati_input[${row}]['Giorno partenza']}']
            ${Giorno_trovato}=    Set Variable    ${True}
            ${Button}=    Set Variable    ${True}
        ELSE
            Click Element    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[1]
            ${Giorno_trovato}=    Set Variable    ${False}
        END
        IF    '${Giorno_trovato}' == '${False}'
            FOR    ${INDEX}    IN RANGE    5
                ${element_exist}=    Run Keyword And Return Status
                ...    Page Should Contain Element
                ...    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/div/div[1]/h3[contains(text(),'${dati_input[${row}]['mese partenza']}')]
                IF    ${element_exist}
                    Click Element    xpath:(//span[text()='${dati_input[${row}]['Giorno partenza']}'])[1]
                    ${Giorno_trovato}=    Set Variable    ${True}
                ELSE
                    Click Element    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[2]
                END
                IF    ${Giorno_trovato}    BREAK
            END
        END
        ${Giorno_trovato}=    Set Variable    ${False}
        # Selezione mese e giorno ritorno
        ${element_exist}=    Run Keyword And Return Status
        ...    Page Should Contain Element
        ...    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/div/div[1]/h3[contains(text(),'${dati_input[${row}]['mese ritorno']}')]
        IF    ${element_exist}
            Click Element    xpath://span[text()='${dati_input[${row}]['Giorno ritorno']}']
            ${Giorno_trovato}=    Set Variable    ${True}
        ELSE
            IF    '${Button}' == '${True}'
                Click Element    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[1]
            ELSE
                Click Element    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[2]
                ${Giorno_trovato}=    Set Variable    ${False}
            END
            Sleep    1
        END
        IF    '${Giorno_trovato}' == '${False}'
            FOR    ${INDEX}    IN RANGE    5
                ${element_exist}=    Run Keyword And Return Status
                ...    Page Should Contain Element
                ...    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/div/div[1]/h3[contains(text(),'${dati_input[${row}]['mese ritorno']}')]
                IF    ${element_exist}
                    Click Element    xpath:(//span[text()='${dati_input[${row}]['Giorno ritorno']}'])[1]
                    ${Giorno_trovato}=    Set Variable    ${True}
                ELSE
                    Click Element    xpath://*[@id="calendar-searchboxdatepicker"]/div/div[1]/button[2]
                END
                IF    ${Giorno_trovato}    BREAK
            END
        END
        # Numero ospiti
        Click Button    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[3]/div/button
        Click Button
        ...    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[3]/div/div/div/div/div[1]/div[2]/button[1]
        Click Button    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[3]/div/div/div/button
        # Viaggio lavoro
        Click Element    xpath://div[text()='Viaggio per lavoro']
        # Invio
        Click Button    xpath://*[@id="indexsearch"]/div[2]/div/div/form/div[1]/div[4]/button
        # Selezione hotel
        Click Element If Visible    xpath:(//*[@data-filters-group="ht_id"]//div[text()='Hotel'])[1]
        Sleep    2
        # Numero stelle
        ${No_hotel_1_star}=    Set Variable    ${False}
        IF    '${dati_input[${row}]['Stelle']}' == '1'
            Click Element If Visible    xpath:(//*[@data-filters-group='class']//div[text()='1 stella'])[1]
            ${No_hotel_1_star}=    Run Keyword And Return Status
            ...    Page Should not Contain
            ...    xpath:(//*[@data-filters-group='class']//div[text()='1 stella'])[1]
        END
        IF    ('${dati_input[${row}]['Stelle']}' == '2') or (${No_hotel_1_star})
            Click Element If Visible    xpath:(//*[@data-filters-group='class']//div[text()='2 stelle'])[1]
        END
        IF    '${dati_input[${row}]['Stelle']}' == '3'
            Click Element If Visible    xpath:(//*[@data-filters-group='class']//div[text()='3 stelle'])[1]
        END
        IF    '${dati_input[${row}]['Stelle']}' == '4'
            Click Element If Visible    xpath:(//*[@data-filters-group='class']//div[text()='4 stelle'])[1]
        END
        IF    '${dati_input[${row}]['Stelle']}' == '5'
            Click Element If Visible    xpath:(//*[@data-filters-group='class']//div[text()='5 stelle'])[1]
        END
        Sleep    2
        # Colazione inclusa
        Click Element If Visible    xpath:(//*[@data-filters-group="mealplan"]//div[text()='Colazione inclusa'])[1]
        Sleep    2
        # Inizia Filtro Prezzo o Votazione
        Click Element    xpath://span[contains(text(),'Ordina per:')]
        IF    '${dati_input[${row}]['Criterio']}' == 'Prezzo'
            Click Element    xpath://span[contains(text(),'Prezzo ')]
        ELSE
            Click Element    xpath://span[contains(text(),'Valutazione struttura (ordine decrescente)')]
        END
        Sleep    3
        # Estrai prezzo
        ${Hotel[0]}=    RPA.Browser.Selenium.Get Text
        ...    xpath:(//*[@data-testid="property-card"])[1]//span[@data-testid="price-and-discounted-price"]
        RPA.Excel.Application.Open Workbook    Bot.xlsx
        RPA.Excel.Application.Set Active Worksheet    Booking
        ${row+2}=    Evaluate    ${row}+2
        RPA.Excel.Application.Write To Cells    Booking    ${row+2}    3    ${Hotel[0]}
        Save Excel
        # Estrai url
        Click Element    xpath://span[text()='Vedi disponibilità']
        Sleep    3
        ${handles}=    Get Window Handles
        Switch Window    ${handles}[1]
        ${Hotel[1]}=    Get Location
        RPA.Excel.Application.Open Workbook    Bot.xlsx
        RPA.Excel.Application.Set Active Worksheet    Booking
        RPA.Excel.Application.Write To Cells    Booking    ${row+2}    2    ${Hotel[1]}
        RPA.Excel.Application.Write To Cells    Booking    ${row+2}    4    ${dati_input[${row}]['Destinazione']}
        RPA.Excel.Application.Write To Cells    Booking    ${row+2}    5    ${dati_input[${row}]['Data partenza']}
        RPA.Excel.Application.Write To Cells    Booking    ${row+2}    6    ${dati_input[${row}]['Data ritorno']}
        Save Excel
        Sleep    1
        RPA.Browser.Selenium.Close Window
    END
