function [data,CH4_composition]=upload_data()
[parameters,numbersOfParameters,units_experimental]=parameters_names(); 
%function to define parameters names and units of measures

%%%%% choose the file you want to import
[file,path] = uigetfile('/Users/marialunaloffredo/Desktop/TESI/data/HERNANDEZ/*.*','Select experimental data file');
data_file = fullfile(path,file); 
for i=1:length(file)
    if(file(i)=='_') %when this symbol appears it enters in the "if" 
        flag=i;
    end
end
CH4_composition=str2double(file(flag+1:flag+2)); %CH4 composition
data=readtable(data_file,'PreserveVariableNames',true); 
data=data(:,numbersOfParameters); 
data.Properties.VariableNames = parameters; %name of columns
 
if strcmp(units_experimental{2},'MPa')
    data.P=data.P*10; % bar
end

return