function [result,rho_EoSf]=singleOpt(table_T,data_array,y1,y2,critprop1,critprop2,R,name_EoS,opt_fun,flag_opt)

    T = table_T;
    rho_data=data_array.rho_exp;
    P=data_array.P;

    if (opt_fun==1)
        option=optimoptions("lsqcurvefit","Algorithm","levenberg-marquardt");
    else
        option=optimoptions("lsqcurvefit","Algorithm","trust-region-reflective","StepTolerance",1e-8,"MaxFunctionEvaluations",1e+6,"MaxIterations",1e+6);
    end
    
    switch flag_opt
        case "bip"
  
            omegaA_v=0.1:0.02:1;   
            omegaB_v=0.01:0.002:0.1;     
            bipStart=-0.15;
            m=length(omegaA_v);
            n=length(omegaB_v);
            bip=zeros(n,m);
            result=zeros(n,m);
           

            for ii=1:m
                omegaA=omegaA_v(ii);
                for jj=1:n
                    omegaB=omegaB_v(jj);
                    
                    rho_EoS = @(x,P) EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,omegaB,x,name_EoS);
                    
                    [valuefinal] = lsqcurvefit(rho_EoS,bipStart,P,rho_data,[-1],[1],option);
                    bip(jj,ii)=valuefinal;
                    rho_EoSf=EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,omegaB,valuefinal,name_EoS);
                    N=length(P);
                    
                end
            end
            result=bip;
       
        case "omegaA"

               
            omegaB_v=0.01:0.002:0.1;
            bip_v=-1:0.0444:1;     
            omegaAstart=0.45724; 
            m=length(omegaB_v);
            n=length(bip_v);
            omegaA=zeros(n,m);
            result=zeros(n,m);
             AAD=zeros(n,m);
          
            for i=1:m
                omegaB=omegaB_v(i);
                for j=1:n
                    bip=bip_v(j);
                    
                    rho_EoS = @(x,P) EoS(P,T,y1,y2,R,critprop1,critprop2,x,omegaB,bip,name_EoS);
                    
                    valuefinal = lsqcurvefit(rho_EoS,omegaAstart,P,rho_data,[-1],[1],option);
                    omegaA(j,i)=valuefinal;
                    rho_EoSf=EoS(P,T,y1,y2,R,critprop1,critprop2,valuefinal,omegaB,bip,name_EoS);
                    N=length(P);
                     AAD(j,i)=sum(abs(rho_EoSf-rho_data)./rho_data)*(100/N);
                    
      
                     
                end
            end
            result=omegaA;
       
        case "omegaB"  

            
           omegaA_v=0.1:0.02:1;
           bip_v=-1:0.0444:1;
           omegaBstart=0.3;
           m=length(omegaA_v);
           n=length(bip_v);
           omegaB=zeros(n,m);
           result=zeros(n,m);
            AAD_vector = [];

            for i=1:m
                omegaA=omegaA_v(i);
                for j=1:n
                    bip=bip_v(j);
                    
                    rho_EoS = @(x,P) EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,x,bip,name_EoS);
                    
                    valuefinal = lsqcurvefit(rho_EoS,omegaBstart,P,rho_data,[-1],[1],option);
                    omegaB(j,i)=valuefinal;
                    rho_EoSf=EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,valuefinal,bip,name_EoS);
                     N=length(P);
                     AAD=sum(abs(rho_EoSf-rho_data)./rho_data);
                    AAD=AAD*100/N;
      
                     AAD_vector = [AAD_vector, AAD];
                end
            end
            result=omegaB;
    end
    
    


return