function [omegaA,omegaB,bip,z_EoSf,rho_EoSf,AAD1,AAD2]=optimization_function_combined(table_T,data_array,y1,y2,critprop1,critprop2,R,name_EoS,opt_fun)

T = table_T;
rho_data=data_array.rho_exp;
P=data_array.P;
value0=[0.45724 0.0778 -0.15];
mw1=critprop1(1);
mw2=critprop2(1);
mw_mixture=mw1*y1+mw2*y2;
z1_data=P.*mw_mixture;
z2_data=z1_data./(R*T);
z_data=z2_data./rho_data;

params0=[value0];

combinedFun = @(x,P) [Z_EoS(P,T,y1,y2,R,critprop1,critprop2,x(1),x(2),x(3),name_EoS); EoS(P,T,y1,y2,R,critprop1,critprop2,x(1),x(2),x(3),name_EoS)] ;


if (opt_fun==1)
    option=optimoptions("lsqcurvefit","Algorithm","levenberg-marquardt");
else
    option=optimoptions("lsqcurvefit","Algorithm","trust-region-reflective");
end



valuefinal = lsqcurvefit(combinedFun,params0,P,[z_data; rho_data],[0;0;-1],[1;1;1],option);
omegaA=valuefinal(1);
omegaB=valuefinal(2);
bip=valuefinal(3);

z_EoSf=Z_EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,omegaB,bip,name_EoS);
rho_EoSf=EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,omegaB,bip,name_EoS);

N=length(P);
AAD1=sum(abs(rho_EoSf-rho_data)./rho_data);
AAD2=sum(abs(z_EoSf-z_data)./z_data);
AAD1=AAD1*100/N;
AAD2=AAD2*100/N;

