clc
close all
clear all


%upload of the data
[data,CH4_composition]=upload_data();

%division of the data according to T values
number_of_T=count_T_values(data);

%generation of an array of tables for eache value of temperature
data_array=data_subdivision(data,number_of_T);

%average T calculation
table_T=T_avg(number_of_T,data_array); 

y1=CH4_composition/100; %CH4
y2=1-y1; %H2
critprop1=input_Properties('CH4'); %CH4
critprop2=input_Properties('H2'); %H2

R=0.08314; %barm3/(kmolK)



omegaA_v=0.1:0.02:1;
omegaB_v=0.01:0.002:0.1;
bip_v=-1:0.05:1;
omegaA_l=length(omegaA_v);
omegaB_l=length(omegaB_v);
bip_l=length(bip_v);
omegaA_PR = 0.45724;
omegaB_PR = 0.0778;
omegaA_RKS = 0.427447;
omegaB_RKS = 0.08664;
bip = -0.15;
rho_RKS=cell(1,number_of_T);
z_RKS=cell(1,number_of_T);
rho_PR=cell(1,number_of_T);
z_PR=cell(1,number_of_T);
z_data=cell(1,number_of_T);

for i=1:number_of_T
    T = table_T{i};
    P = data_array{i}.P;
    for j=1:bip_l
                z_PR{j,i}=Z_EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA_PR,omegaB_PR,bip_v(j),"PR");
                rho_PR{j,i}=EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA_PR,omegaB_PR,bip_v(j),"PR");
                 z_RKS{j,i}=Z_EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA_RKS,omegaB_RKS,bip_v(j),"RKS");
                rho_RKS{j,i}=EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA_RKS,omegaB_RKS,bip_v(j),"RKS");
                z_data{j,i}=z_data_update(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R);
              
              
                plot_sensitivity(data_array,table_T,number_of_T,i,j,rho_PR,"PR");
                plot_sensitivity(data_array,table_T,number_of_T,i,j,rho_RKS,"RKS");
                k=i+14;
                  plot_sens1(data_array,table_T,number_of_T,i,j,k,z_PR,"PR");
                   plot_sens1(data_array,table_T,number_of_T,i,j,k,z_RKS,"RKS");
%     
%      if i == number_of_T
%                % if j == omegaA_l  
%                 filename = 'rho.png';
%                  %filename = 'AAD.png';
%                  cartella_destinazione = '/Users/marialunaloffredo/Desktop/figure/grafici sensitivity analysis EoS (no opt)/RKS/omegaA/50';
%                  saveas(gcf, fullfile(cartella_destinazione, filename));
%               %  end
%      end

    end
end
