clc
close all
clear all


%upload of the data
[data,CH4_composition]=upload_data();

%division of the data according to T values
number_of_T=count_T_values(data);

%generation of an array of tables for eache value of temperature
data_array=data_subdivision(data,number_of_T);

%average T calculation
table_T=T_avg(number_of_T,data_array); 
L=length(table_T);
y1=CH4_composition/100; %CH4
y2=1-y1; %H2
critprop1=input_Properties('CH4'); %CH4
critprop2=input_Properties('H2'); %H2

R=0.08314; %barm3/(kmolK)

% mw1=critprop1(1);
% mw2=critprop2(1);
% mw_mixture=mw1*y1+mw2*y2;
% z1_data=P.*mw_mixture;
% z2_data=z1_data./(R*T);
% z_data=z2_data./rho_data;


optimal_valuesPR=cell(3,number_of_T);
rho_PR=cell(number_of_T,1);
z_PR=cell(number_of_T,1);
AAD1_PR=zeros(1,number_of_T);
AAD2_PR=zeros(1,number_of_T);
% omegaA_v=0.1:0.01:0.6;
% omegaB_v=0.01:0.01:0.1;
% bip_v=-0.15:0.01:0.6;
% check_valuesPR=cell(3,number_of_T);

optimal_valuesRKS=cell(3,number_of_T);
rho_RKS=cell(number_of_T,1);
z_RKS=cell(number_of_T,1);
AAD1_RKS=zeros(1,number_of_T);
AAD2_RKS=zeros(1,number_of_T);
% check_valuesRKS=cell(3,number_of_T);
% cartella_destinazione = '/Users/marialunaloffredo/Desktop/figure/OPT_3/50';

for i=1:number_of_T
% 
%%%%%%%%% Optimization for PR with 1=levenberg-marquardt , 2=trust-region-reflective
        [omegaA,omegaB,bip,z_EoSf,rho_EoSf,AAD1,AAD2]=optimization_function_combined_PR(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,"PR",1);
        optimal_valuesPR{1,i}=omegaA;
        optimal_valuesPR{2,i}=omegaB;
        optimal_valuesPR{3,i}=bip;
        rho_PR{i,1}=rho_EoSf;
        z_PR{i,1}=z_EoSf;
        AAD1_PR(1,i)=AAD1;
        AAD2_PR(1,i)=AAD2;
        j=i;
        k=1;
        z_data{i,1}=z_data_update(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R);
         plot_opt_final_PR(data_array,table_T,rho_PR,z_PR,i,j,k,z_data);
%         filename = 'grafico i.png';
% saveas(gcf, fullfile(cartella_destinazione, filename));
end


%%%%%%%%% Check for PR
%         [omegaA_check,omegaB_check,bip_check,Objectivefunction]=opt_check(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,"PR",omegaA_v,omegaB_v,bip_v);
%         check_valuesPR{1,i}=omegaA_check;
%         check_valuesPR{2,i}=omegaB_check;
%         check_valuesPR{3,i}=bip_check;

% obj_min=min(min(min(Objectivefunction)));
% [=find(Objectivefunction==obj_min);
for i=1:number_of_T
%%%%%%%%% Optimization for RKS with 1=levenberg-marquardt , 2=trust-region-reflective
        [omegaA,omegaB,bip,z_EoSf,rho_EoSf,AAD1,AAD2]=optimization_function_combined_RKS(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,"RKS",1);
        optimal_valuesRKS{1,i}=omegaA;
        optimal_valuesRKS{2,i}=omegaB;
        optimal_valuesRKS{3,i}=bip;
        rho_RKS{i,1}=rho_EoSf;
        z_RKS{i,1}=z_EoSf;
        AAD1_RKS(1,i)=AAD1;
        AAD2_RKS(1,i)=AAD2;
        j=i+L;
        k=i+L;
        z_data{i,1}=z_data_update(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R);
         plot_opt_final_RKS(data_array,table_T,rho_RKS,z_RKS,i,j,k,z_data)
%         filename = 'grafico i+j.png';
% saveas(gcf, fullfile(cartella_destinazione, filename));
%%%%%%%%% Check for RKS
%         [omegaA_check,omegaB_check,bip_check]=opt_check(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,"RKS",omegaA_v,omegaB_v,bip_v);
%         check_valuesRKS{1,i}=omegaA_check;
%         check_valuesRKS{2,i}=omegaB_check;
%         check_valuesRKS{3,i}=bip_check;
        
end


for i=1:number_of_T
    z_data{i,1}=z_data_update(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R);
    j=i+2*L;
    k=i+2*L;
    plot_opt_final_PRvsRKS(data_array,table_T,rho_PR,z_PR,rho_RKS,z_RKS,i,j,k,z_data)
%      plot_opt_final(data_array,table_T,rho_RKS,z_RKS,i,j,z_data);
%     filename = 'grafico i+j.png';
end


%plot_opt(data_array,table_T,number_of_T,rho_PR,rho_RKS,z_PR,z_RKS,z_data);

% Specifica la cartella di destinazione
% cartella_destinazione = '/Users/marialunaloffredo/Desktop/figure/OPT_3/50';


% Salva la figura come PNG nella cartella specificata

% filename = 'grafico.png';
% saveas(gcf, fullfile(cartella_destinazione, filename));

% % Salva la figura come JPEG nella cartella specificata con una determinata risoluzione (dpi)
% dpi = 700; % Imposta la risoluzione a 300 dpi
% filename = 'grafico.jpg';
% print(gcf, fullfile(cartella_destinazione, filename), '-djpeg', ['-r' num2str(dpi)]);

% % Salva la figura come PDF nella cartella specificata
% filename = 'grafico.pdf';
% print(gcf, fullfile(cartella_destinazione, filename), '-dpdf');








% for i=1:number_of_T
%     [omegaA_check,omegaB_check,bip_check]=opt_check(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,name_EoS,omegaA_v,omegaB_v,bip_v);
%      check_valuesPR{1,i}=omegaA_check;
%      check_valuesPR{2,i}=omegaB_check;
%      check_valuesPR{3,i}=bip_check;
% end



% for i=1:number_of_T
%         [omegaA,omegaB,bip,rho_EoSf]=optimization_function(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,name_EoS,opt_fun);
%         optimal_valuesRKS{1,i}=omegaA;
%         optimal_valuesRKS{2,i}=omegaB;
%         optimal_valuesRKS{3,i}=bip;
%         rho_RKS{i,1}=rho_EoSf;
% end

% omegaA_v=0.1:0.01:0.6;
% omegaB_v=0.01:0.01:0.1;
% bip_v=0.1:0.01:0.6;
% check_valuesRKS=cell(3,number_of_T);

% for i=1:number_of_T
%     [omegaA_check,omegaB_check,bip_check]=opt_check(table_T{i},data_array{i},y1,y2,critprop1,critprop2,R,name_EoS,omegaA_v,omegaB_v,bip_v);
%      check_valuesRKS{1,i}=omegaA_check;
%      check_valuesRKS{2,i}=omegaB_check;
%      check_valuesRKS{3,i}=bip_check;
% end

% for i=1:number_of_T
%     T = table_T{i};
%     rho_data=data_array{i}.rho_exp;
%     P=data_array{i}.P;
%     rho_pengrob=rho_PR{i};
%     rho_redsoave=rho_RKS{i};
%     P_n=length(P);
%     figure (number_plots)
%     plot(rho_pengrob(1:P_n),P.*1e-6,'m*-',rho_redsoave(1:P_n),P.*1e-6,'g*-',rho_data(1:P_n),P.*1e-6,'bo-');
%     legend('PR','RKS','Experimental Data','Location','NorthWest');
%     xlabel('\rho(kg/m^3)');
%     ylabel('P(MPa)');
% end

%%surf for bip constant and omegaA e omegaB changing
% omegaA_v=[0.01:0.01:1];
% omegaB_v=[0.01:0.01:1];
% bip=0.4;
% T = table_T{1};
% rho_data=data_array{1}.rho_exp;
% P=data_array{1}.P;
% aa=0;
% m=length(omegaA_v);
% n=length(omegaB_v);
% Objectivefunction=zeros(m,n);
% 
% for ii=1:length(omegaA_v)
%     omegaA=omegaA_v(ii);
%    for jj=1:length(omegaB_v)
%     omegaB=omegaB_v(jj);
%     aa=aa+1;
%     rho_EoS{aa}= EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,omegaB,bip,name_EoS);
%     residual=rho_EoS{aa}-rho_data;
%     Objectivefunction(ii,jj)=sum((norm(residual)).^2);
%    end
% end 
% 
% minValue=Objectivefunction(1);
% omegaA_check=0;
% omegaB_check=0;
%


% % 
% for i = 1:size(Objectivefunction, 1)
%     for j = 1:size(Objectivefunction, 2)
% %        
% %         % Se l'elemento corrente è minore del valore minimo, lo sostituisce
%         if Objectivefunction(i,j) < minValue
%             minValue = Objectivefunction(i,j);
%             omegaA_check=omegaA_v(i);
%             omegaB_check=omegaB_v(j);
%         end
%     end
% end
% 
% figure (1)
% surf(omegaA_v,omegaB_v,Objectivefunction)
% xlim([0.01 1]);
% ylim([0.01 1]);
% zlim([0 50]);
% caxis([0 50]);
% colormap(jet);
% colorbar;
 
%  omegaA_bip=0.4
%  omegaB_bip=0.07
%  bip_v=-0.2:0.01:0.6;
%  rho_PR=cell(1,length(bip_v));
%  Objectivefunction=zeros(1,length(bip_v));
% 
%  for ii=1:length(bip_v)
%       rho_EoS{ii}= EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA_bip,omegaB_bip,bip_v(ii),name_EoS);
%       residual=rho_PR{ii}-rho_exp1;
%      Objectivefunction(ii)=sum((norm(residual)).^2);
%  end
% 
%  figure (2)
%  plot(bip_v,Objectivefunction)
% 
% minValue=Objectivefunction(1);
% bip_check=0;
% 
% 
% for i = 1:size(Objectivefunction, 1)
% %         % Se l'elemento corrente è minore del valore minimo, lo sostituisce
%         if Objectivefunction(i) < minValue
%             minValue = Objectivefunction(i);
%             bip_check=bip_v(i);
%         end
%     end
% end
