function [critProp]=input_Properties(fluid)
%%% Units
% Temperature: K
% Pressure: Pa
% molar volume: m3/kmol
% Molecular weight: kg/kmol

% Data obtained from PVTi software

switch fluid
    case 'H2' 
        MW=2.01588; 
        Tc=33.19;
        Pc=12.9999975;
        vc=65*(10^-3); 
        omega=-0.218;
        critProp=[MW,Tc,Pc,vc,omega];
    case 'CH4' 
        MW=16.04246;
        Tc=190.564;
        Pc=46.04208; 
        vc=98*(10^-3); 
        omega=0.013;
        critProp=[MW,Tc,Pc,vc,omega];
end
return