function  [omegaA,omegaB,rho_EoSf,AAD_vector]=doubleOpt(table_T,data_array,y1,y2,critprop1,critprop2,R,name_EoS,opt_fun,flag_opt)

    T = table_T;
    rho_data=data_array.rho_exp;
    P=data_array.P;
    

    if (opt_fun==1)
        option=optimoptions("lsqcurvefit","Algorithm","levenberg-marquardt");
    else
        option=optimoptions("lsqcurvefit","Algorithm","trust-region-reflective","StepTolerance",1e-8,"MaxFunctionEvaluations",1e+6,"MaxIterations",1e+6);
    end


            bip_v=-1:0.0444:1;
            value0=[0.45724 0.0778];
            

            m=length(bip_v);
            omegaA=zeros(m,1);
            omegaB=zeros(m,1);
            AAD_vector = [];

            for ii=1:m
                    bip=bip_v(ii);
                    rho_EoS = @(x,P) EoS(P,T,y1,y2,R,critprop1,critprop2,x(1),x(2),bip,name_EoS);
                    
                    valuefinal = lsqcurvefit(rho_EoS,value0,P, rho_data,[0;0],[1;1],option);
                    omegaA(ii,1)=valuefinal(1);
                    omegaB(ii,1)=valuefinal(2);

                    rho_EoSf=EoS(P,T,y1,y2,R,critprop1,critprop2,valuefinal(1),valuefinal(2),bip,name_EoS);
                    N=length(P);
                    AAD=sum(abs(rho_EoSf-rho_data)./rho_data);
                    AAD=AAD*100/N;
      
                     AAD_vector = [AAD_vector, AAD];
            end
end