function z_EoS= Z_EoS(P,T,y1,y2,R,critprop1,critprop2,omegaA,omegaB,bip,name_EoS)

%1=CH4
%2=H2
MW1=critprop1(1);
Tc1=critprop1(2);
Pc1=critprop1(3);

omega1=critprop1(5);
MW2=critprop2(1);
Tc2=critprop2(2);
Pc2=critprop2(3);

omega2=critprop2(5);


b1 = omegaB*R*Tc1/Pc1;
b2 = omegaB*R*Tc2/Pc2;
b_mix= y1*b1 + y2*b2;

if (name_EoS=="PR")
 m1 = 0.37464 + 1.54226*omega1 - 0.26992*omega1^2; 
 m2 = 0.37464 + 1.54226*omega2 - 0.26992*omega2^2; 
else
 m1 = 0.48 + 1.574*omega1 - 0.176*omega1^2; 
 m2 = 0.48 + 1.574*omega1 - 0.176*omega1^2; 
end

alpha_spec1 = (1+m1*(1-(T/Tc1)^0.5))^2;
alpha_spec2 = (1+m2*(1-(T/Tc2)^0.5))^2;
a1 =omegaA*R^2*Tc1^2/Pc1*alpha_spec1;
a2 = omegaA*R^2*Tc2^2/Pc2*alpha_spec2;
a_mix = y1^2*a1 + y2^2*a2 +(1-bip)*2*y1*y2*(a1*a2)^0.5;


a = zeros(length(P),1);
b = zeros(length(P),1);
c = zeros(length(P),1);
d = zeros(length(P),1);
z_EoS=zeros(length(P),1);

if (name_EoS=="PR")
   for jj=1:length(P)
       B= b_mix*P(jj)/(R*T);
       A= a_mix*P(jj)/(R^2*T^2);
    a(jj,1) = 1;
    b(jj,1) = B - 1;
    c(jj,1) = -3*B^2-2*B+A;
    d(jj,1) = B^3+B^2-A*B;
    r = [a(jj) b(jj) c(jj) d(jj)];
    z = sort(roots(r));
           for ii=1:3
                if imag(z(ii))==0
                     z_EoS(jj)=z(ii);
                 else
                     continue
                 end
            end
               
   end
else
    for jj=1:length(P)
    a(jj) = 1;
    b(jj) = - 1;
    c(jj) = -((b_mix*P(jj))^2)/(R*T)^2-(b_mix*P(jj))/(R*T)+(a_mix*P(jj))/(R*T)^2;
    d(jj) = -((P(jj)^2)/(R*T)^3)*a_mix*b_mix;
    r = [a(jj) b(jj) c(jj) d(jj)];
   z = sort(roots(r));
           for ii=1:3
                if imag(z(ii))==0
                     z_EoS(jj)=z(ii);
                 else
                     continue
                 end
            end
     end
    end
end



