import abc
from abc import abstractmethod
import numpy as np

class CLSP(object):
    """Classe base per modello CLSP (Capacitated Lot-Sizing Problem)"""

    __metaclass__ = abc.ABCMeta

    @abstractmethod
    def __init__(self, **setting):
        """
        setting contiene un dizionario con i parametri
        """
        self.name = None
        self.setting = setting

    def set_initial_inventory(self, initial_inventory):
        self.initial_inventory = initial_inventory

    @abstractmethod
    def solve(self, instance, scenarios: np.array):
        pass

