# CLSP
This repository solves the Capacitated Lot Sizing Problem (CLSP) under demand uncertainty, using the Fix &amp; Relax matheuristics.

The package 'solvers' contains the classes CLSP, CLSP_Det, CLSP_S, CLSP_S_FR.
CLSP is a base class for CLSP.
CLSP_Det is a class that defines and solves the CLSP with deterministic demand and safety stocks on the inventory.
CLSP_S is a class that defines and solves the CLSP with stochastic demand in the standard way (branch and bound).
CLSP_S_FR is a class that defines and solves the CLSP with stochastic demand using the Fix and Relax matheuristics to reduce the computational time.

The package instances contains the classes Instance e Instance_Det.
Instance is a class for instances of CLSP problem with stochastic demand.
Instance_Det is a class for instances of CLSP problem with deterministic demand.

The package functions defines functions useful when dealing with a stochastic demand represented by a scenario tree and functions useful for generating demand paths.

scenarioTree is a package that contains the classes scenarioTreeSobol and scenarioTree_standard.
scenarioTreeSobol is a class that creates a scenario tree and uses Sobol low-discrepance sequences to sample demands in the nodes.
scenarioTree_standard is a class that creates a scenario tree with demand from a normal multivariate distribution (using the standard Python method to sample).

AnalisiAlberiFR is the Python code used to compare in sample performances of the standard solver and the one that implements the Fix and Relax Matheursitics.

ANOVA_DatiAlberiFR is the Python code for ANOVA and linear regressions, done on simulations in sample.

AnalisiGrafica_MediaMobile is the Python code used to obtain moving averages plots about out of sample rolling horizon simulations, both with standard scenario tree and with Sobol scenario tree.

GraficiConfrontoCostiTotali is the Python code used to obtain plots that compare total costs of out of sample rolling horizon simulations, both with standard scenario tree and with Sobol scenario tree.

GraficiConfrontoSolverDet is the Python code used to obtain plots that compare total costs of out of sample rolling horizon simulations, with the deterministic solver and with the modified one (with safety stocks after two time periods).

GraficiConfrontoT_alpha is the Python code used to obtain plots that show the results of determinsitic solver, varying the safety level alpha and the length of the horizon T.

GraficiCostiTotaliDet is the Python code used to obtain plots that compare total costs of out of sample rolling horizon simulations, both with stochastic solvers and with the deterministic one.

BuildingBlocks is a short Python code that shows how the building blocks of the project work.