import pandas as pd
from matplotlib import pyplot as plt

#IMPORT DEL DATAFRAME

#DATAFRAME 1: COSTI TOTALI STOCASTICI
df=pd.read_csv('dataframes/DF_CostiTotali7.csv')
#DATAFRAME 2: COSTI TOTALI DETERMINISTICI
dfDet=pd.read_csv('dataframes/DF_CostiTotaliDet10.csv')

#GRAFICI VARI

plt.style.use("ggplot")

#VETTORE DEI BRANCHING FACTORS
branching_factors=[[5,3,2],[6,5,2],[5,3,2,2],[9,5,2,1],[5,3,3,2,1]]

#GRAFICI DI CONFRONTO TEMPI E COSTI TRA SOLVER DETERMINISTICO
#E STOCASTICO

fig,ax=plt.subplots(nrows=1, ncols=1, sharex=True)
fig2,ax2=plt.subplots(nrows=1, ncols=1, sharex=True)

#GRAFICI DI CONFRONTO TRA DIVERSI T ED ALPHA
#FOR SUL NUMERO DI PERIODI SCARTATI 
#(NEL NOSTRO CASO SONO STATI TUTTI CONSIDERATI)
for disc in [0]:

    #DATAFRAME 1 TEMPORANEO, CON disc PERIODI SCARTATI
    df_temp=df[(df["Discarded periods"]==disc)]
    #DATAFRAME 1 TEMPORANEO DIVISO A GRUPPI, IN BASE A TIPO 
    #DELL'ALBERO (STANDARD O SOBOL) E AL FATTORE DI
    #RAMIFICAZIONE
    groups=df_temp.groupby(['Tree type','Branching factors'])

    #DATAFRAME 2 TEMPORANEO, CON disc PERIODI SCARTATI E T=10
    #(PERCHE' SI E' VISTO CHE HA RISULTATI MIGLIORI)
    df_temp_det1=dfDet[(dfDet['Discarded periods']==disc) & (dfDet['T']==10)]
    #DATAFRAME 2 TEMPORANEO DIVISO A GRUPPI, IN BASE AD ALPHA
    groups_Det=df_temp_det1.groupby('alpha')
    
    branch_fact=[]
    y0=[]
    y1=[]
    y2=[]
    y3=[]
    y4=[]
    y5=[]
    y6=[]
    y7=[]
    y8=[]
    
    #FOR PER SCANDIRE I 5 BRANCHING FACTORS
    for i in range(5):

        branching_factor=branching_factors[i]
        str="".join(["[",",".join([f"{ele}" for ele in branching_factor]),"]"])

        branch_fact.append(str)

        #COSTO MEDIO STOCASTICO CON IL BRANCHING FACTOR ESAMINATO
        #DAL CICLO FOR E ALBERO STANDARD
        y0.append(groups.mean()['Cost'][0][str])

        #COSTO MEDIO STOCASTICO CON IL BRANCHING FACTOR ESAMINATO
        #DAL CICLO FOR E ALBERO SOBOL
        y1.append(groups.mean()['Cost'][1][str])

        #TEMPO MEDIO STOCASTICO CON IL BRANCHING FACTOR ESAMINATO
        #DAL CICLO FOR E ALBERO STANDARD
        y6.append(groups.mean()['Time'][0][str])

        #TEMPO MEDIO STOCASTICO CON IL BRANCHING FACTOR ESAMINATO
        #DAL CICLO FOR E ALBERO SOBOL    
        y7.append(groups.mean()['Time'][1][str])

        #DUE MIGLIORI COSTI DTERMINISTICI:    
        #COSTO MEDIO DETERMINISTICO CON T=10 ED ALPHA=0.7
        y2.append(groups_Det.mean()['Cost'][0.7])
        #COSTO MEDIO DETERMINISTICO CON T=10 ED ALPHA=0.75
        y3.append(groups_Det.mean()['Cost'][0.75])
        #TEMPO MEDIO SOLVER DETERMINISTICO
        y8.append(dfDet.mean()['Time'])

    #STAMPA DEL TEMPO MEDIO DETERMINISTICO        
    print('Tempo medio solver deterministico: {}'.format(y8[0]))

    #PLOT DI CONFRONTO DEI COSTI MEDI (STOCASTICI E DETERMINISTICI)
    ax.plot(branch_fact,y0,marker=".",label='F&R')
    ax.plot(branch_fact,y1,marker=".",label='F&R+Sobol')
    ax.plot(branch_fact,y2,marker=".",label='T=10, alpha=0.7')
    ax.plot(branch_fact,y3,marker=".",label='T=10, alpha=0.75')

    ax.set_title("Confronto costi modello \n stocastico e deterministico")

    ax.legend()
    
    ax.set_ylabel('Costo')

    ax.set_xlabel('Branching factors')

    #PLOT DI CONFRONTO DEI TEMPI MEDI (STOCASTICI E DETERMINISTICI)
    ax2.plot(branch_fact,y6,marker=".",label='F&R')
    ax2.plot(branch_fact,y7,marker=".",label='F&R+Sobol')
    ax2.plot(branch_fact,y8,marker=".",label='Deterministico')

    ax2.set_title("Confronto tempi modello \n stocastico e deterministico")

    ax2.legend()
    
    ax2.set_ylabel('Tempo')

    ax2.set_xlabel('Branching factors')

            
plt.show()
#GRAFICI DI CONFRONTO DEI COSTI DISAGGREGATI
#FOR SUL NUMERO DI PERIODI SCARTATI 
#(NEL NOSTRO CASO SONO STATI TUTTI CONSIDERATI)
for disc in[0]:
    fig,ax=plt.subplots(nrows=1, ncols=1,sharey=True)

    #DATAFRAME 1 TEMPORANEO CON disc ISTANTI SCARTATI
    df_temp=df[(df["Discarded periods"]==disc)]
    #DATAFRAME 1 TEMPORANEO DIVISO A GRUPPI, IN BASE A TIPO 
    #DELL'ALBERO (STANDARD O SOBOL) E AL FATTORE DI
    #RAMIFICAZIONE
    types=df_temp.groupby(['Tree type','Branching factors'])
    
    #DATAFRAME 2 TEMPORANEO, CON disc PERIODI SCARTATI E T=10
    #(PERCHE' SI E' VISTO CHE HA RISULTATI MIGLIORI)
    df_temp_det1=dfDet[(dfDet['Discarded periods']==disc) & (dfDet['T']==10)]
    #DATAFRAME 2 TEMPORANEO DIVISO A GRUPPI, IN BASE AD ALPHA
    types2=df_temp_det1.groupby('alpha')

    branch_fact=[]
    y1=[]
    y2=[]
    y3=[]
    y4=[]
    y5=[]
    y6=[]

    #FOR PER SCANDIRE I 5 BRANCHING FACTOR ESAMINATI
    for i in range(5):
        
        branching_factor=branching_factors[i]

        str="".join(["[",",".join([f"{ele}" for ele in branching_factor]),"]"])

        branch_fact.append(str)
        
        #COSTO DI MAGAZZINO MEDIO COL SOLVER STOCASTICO, ALBERO STANDARD
        #ED IL FATTORE DI RAMIFICAZIONE IN QUESTIONE
        y1.append(types.mean()['h_cost'][0][str])
        #COSTO DI VENDITE PERSE MEDIE COL SOLVER STOCASTICO, ALBERO 
        #STANDARD ED IL FATTORE DI RAMIFICAZIONE IN QUESTIONE
        y2.append(types.mean()['g_cost'][0][str])
        #COSTO DI SETUP MEDIO COL SOLVER STOCASTICO, ALBERO STANDARD
        #ED IL FATTORE DI RAMIFICAZIONE IN QUESTIONE
        y3.append(types.mean()['f_cost'][0][str])

        #COSTO DI MAGAZZINO MEDIO COL SOLVER DETERMINISTICO, T=10
        #ED ALPHA=0.7
        y4.append(types2.mean()['h_cost'][0.7])
        #COSTO DI VENDITE PERSE MEDIE COL SOLVER DETERMINISTICO, T=10
        #ED ALPHA=0.7
        y5.append(types2.mean()['g_cost'][0.7])
        #COSTO DI SETUP MEDIO COL SOLVER DETERMINISTICO, T=10
        #ED ALPHA=0.7
        y6.append(types2.mean()['f_cost'][0.7])

    #PLOT DI CONFRONTO DEI COSTI DISAGGREGATI
    ax.plot(branch_fact,y1,label='h_cost stocastico')
    ax.plot(branch_fact,y4,label='h_cost deterministico')

    ax.set_title('Confronto costi disaggregati')

    ax.plot(branch_fact,y2,label='g_cost stocastico')
    ax.plot(branch_fact,y5,label='g_cost deterministico')

    
    ax.plot(branch_fact,y3,label='f_cost stocastico')
    ax.plot(branch_fact,y6,label='f_cost deterministico')


    ax.set_xlabel('Branching factors')
    ax.legend(bbox_to_anchor=(0.8, 0.42))

plt.show()